/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.alignhypothesis;

import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.AlignedSequence;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class BoundsMarker
implements Callable<AlignedSequence> {
    private ArrayList<int[]> sequenceMatrix;
    private Map<Integer, List<INode>> prefixNodes;
    private Map<Integer, List<INode>> suffixNodes;
    private int sequenceId;
    private ExecutorService service = Executors.newFixedThreadPool(2);

    public void setSequenceMatrix(ArrayList<int[]> sequenceMatrix) {
        this.sequenceMatrix = sequenceMatrix;
    }

    public void setPrefixNodes(Map<Integer, List<INode>> prefixNodes) {
        this.prefixNodes = prefixNodes;
    }

    public void setSuffixNodes(Map<Integer, List<INode>> suffixNodes) {
        this.suffixNodes = suffixNodes;
    }

    @Override
    public AlignedSequence call() throws Exception {
        return this.process(this.sequenceId);
    }

    public void setSequenceId(int sequenceId) {
        this.sequenceId = sequenceId;
    }

    public AlignedSequence process(final int sequenceId) throws InterruptedException, ExecutionException {
        final int[] sequence = this.sequenceMatrix.get(sequenceId);
        final AlignedSequence as = new AlignedSequence(sequenceId, sequence.length);
        Runnable suffix = new Runnable(){

            @Override
            public void run() {
                HashSet<Integer> processed = new HashSet<Integer>();
                int i = 0;
                while (i < sequence.length) {
                    int type = sequence[i];
                    if (!processed.contains(type)) {
                        processed.add(type);
                        List suffixList = (List)BoundsMarker.this.suffixNodes.get(type);
                        if (suffixList != null) {
                            for (INode node : suffixList) {
                                Collection<IPosition> positions = node.getReferencedPositions();
                                for (IPosition position : positions) {
                                    IPosition myPosition;
                                    if (sequenceId != position.getSequenceIndex() || (myPosition = position).getElementIndex() < 0 || myPosition.getElementIndex() >= sequence.length) continue;
                                    as.registerStartHypothesis(myPosition, positions, node.getDepth(), BoundsMarker.this.sequenceMatrix);
                                }
                            }
                        }
                    }
                    ++i;
                }
                as.trimStartNodes();
            }
        };
        Future<?> suffixFuture = this.service.submit(suffix);
        Runnable prefix = new Runnable(){

            @Override
            public void run() {
                HashSet<Integer> processed = new HashSet<Integer>();
                int i = 0;
                while (i < sequence.length) {
                    int type = sequence[i];
                    if (!processed.contains(type)) {
                        processed.add(type);
                        List prefixList = (List)BoundsMarker.this.prefixNodes.get(type);
                        if (prefixList != null) {
                            for (INode node : prefixList) {
                                Collection<IPosition> positions = node.getReferencedPositions();
                                for (IPosition position : positions) {
                                    IPosition myPosition;
                                    if (position.getSequenceIndex() != sequenceId || (myPosition = position).getElementIndex() < 0 || myPosition.getElementIndex() >= sequence.length) continue;
                                    as.registerEndHypothesis(myPosition, positions, node.getDepth(), BoundsMarker.this.sequenceMatrix);
                                }
                            }
                        }
                    }
                    ++i;
                }
                as.trimEndNodes();
            }
        };
        Future<?> prefixFuture = this.service.submit(prefix);
        suffixFuture.get();
        prefixFuture.get();
        return as;
    }
}

