/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.alignhypothesis;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.TypeMapping;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.BoundsMarker;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.access.impl.AlignedSequenceAccessAdapter;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.AlignedSequence;
import de.uni_koeln.spinfo.tesla.component.ngramtree.access.INgramTreeAccessAdapter;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INgramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.Node;
import de.uni_koeln.spinfo.tesla.component.util.MatrixLoader;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.uni-koeln.de/space/sschwieb", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="SOG (Boundaries)", summary="Generates structural hypotheses based on the shared context of two or more sequences of elements.", bigO="", version="1.0", reusableResults=true))
public class HypothesisGenerator
extends TeslaComponent {
    private static final long serialVersionUID = 1214407936563L;
    @Configuration(name="Minimum Context Width Left", defaultValue="2")
    private int minLeft = 2;
    @Configuration(name="Minimum Context Width Right", defaultValue="2")
    private int minRight = 2;
    @Configuration(name="Sequence Start Weight", defaultValue="1")
    private int sentenceStart = 1;
    @Configuration(name="Sequence End Weight", defaultValue="1")
    private int sentenceEnd = 1;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.ngramTreeGenerator", name="Suffix Tree")
    private INgramTreeAccessAdapter<INgramTree> suffixTree;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.ngramTreeGenerator", name="Prefix Tree")
    private INgramTreeAccessAdapter<INgramTree> prefixTree;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", description="The sequences to align (for instance, sentences)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items", description="The items to align (for instance, words)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> words;
    @OutputAdapter(dataObject=AlignedSequence.class, type=DefaultTunguskaOutputAdapter.class, name="Hypotheses", accessAdapterImpl=AlignedSequenceAccessAdapter.class, description="Alignment Hypotheses", bufferSize=50)
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.structure.AlignmentHypothesisGenerator")
    private IOutputAdapter<AlignedSequence> out;
    private int maxThreads = 2;
    private ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix;
    private ArrayList<Annotation<IAnchoredElement>> sequencesList;
    private ExecutorService executors = Executors.newFixedThreadPool(this.maxThreads);
    private Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    private ArrayList<int[]> sequenceMatrix;

    @Run
    public Result run() throws Exception {
        this.setProgressName("Preprocessing");
        this.logger.info((Object)"Loading data...");
        MatrixLoader loader = new MatrixLoader();
        InputIterator signals = this.words.getAllSignalIds();
        ArrayList<String> signalIds = new ArrayList<String>();
        while (signals.hasNext()) {
            signalIds.add((String)signals.next());
        }
        this.sequenceMatrix = loader.loadData(signalIds, this, this.sequences, this.words, 20.0);
        this.dataMatrix = loader.getDataMatrix();
        this.sequencesList = loader.getSequencesList();
        loader.release();
        if (this.cancelled()) {
            return Result.CANCELLED;
        }
        this.setProgressName("Preprocessing");
        this.maxThreads = Math.max(2, Runtime.getRuntime().availableProcessors() / 2);
        this.executors = Executors.newFixedThreadPool(this.maxThreads);
        this.logger.info((Object)"Optimizing N-Gram trees");
        Map<Integer, List<INode>> suffixNodes = this.getTypeMapping(this.suffixTree, this.minLeft, this.sentenceStart);
        Map<Integer, List<INode>> prefixNodes = this.getTypeMapping(this.prefixTree, this.minRight, this.sentenceEnd);
        this.process(suffixNodes, prefixNodes);
        this.sequenceMatrix.clear();
        if (this.cancelled()) {
            return Result.CANCELLED;
        }
        super.setProgressName("Start- and endpoints of all hypotheses were generated.");
        return Result.OK;
    }

    public void process(Map<Integer, List<INode>> suffixNodes, Map<Integer, List<INode>> prefixNodes) throws InterruptedException, ExecutionException {
        ArrayList<Future<AlignedSequence>> results = new ArrayList<Future<AlignedSequence>>();
        ArrayList<BoundsMarker> pool = new ArrayList<BoundsMarker>(this.maxThreads);
        int i = 0;
        while (i < this.maxThreads) {
            BoundsMarker processor = new BoundsMarker();
            processor.setSequenceMatrix(this.sequenceMatrix);
            processor.setSuffixNodes(suffixNodes);
            processor.setPrefixNodes(prefixNodes);
            pool.add(processor);
            ++i;
        }
        ArrayList<BoundsMarker> callables = new ArrayList<BoundsMarker>();
        double current = 20.0;
        double step = 80.0 / (double)this.sequenceMatrix.size();
        int next = 0;
        int i2 = 0;
        while (i2 < this.sequenceMatrix.size()) {
            BoundsMarker callable = (BoundsMarker)pool.get(next++);
            callable.setSequenceId(i2);
            callables.add(callable);
            results.add(this.executors.submit(callable));
            if (next == this.maxThreads) {
                this.storeResults(results, this.dataMatrix, this.sequencesList);
                callables.clear();
                results.clear();
                next = 0;
            }
            if (i2 % 2500 == 0) {
                this.logger.info((Object)("Processed " + i2 + " sequences."));
            }
            this.setProgress((int)(current += step));
            if (this.cancelled()) break;
            ++i2;
        }
        this.logger.info((Object)"Storing last results...");
        this.executors.shutdown();
        this.storeResults(results, this.dataMatrix, this.sequencesList);
        this.logger.info((Object)"Releasing resources...");
    }

    protected void storeResults(List<Future<AlignedSequence>> results, ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix, ArrayList<Annotation<IAnchoredElement>> baseAnnotations) throws InterruptedException, ExecutionException {
        int x = 0;
        while (x < results.size()) {
            AlignedSequence constituents = results.get(x).get();
            if (constituents != null) {
                constituents.setSequence(dataMatrix.get(constituents.getSequenceId()));
                Annotation anno = this.out.getAnnotationFactory().newAnnotation(baseAnnotations.get(constituents.getSequenceId()), (DataObject)constituents, TypeMapping.NONE);
                this.out.store(anno);
            }
            ++x;
        }
        results.clear();
    }

    private Map<Integer, List<INode>> getTypeMapping(INgramTreeAccessAdapter<INgramTree> adapter, int minDepth, int bonus) {
        INgramTree tree = adapter.getTree();
        Map<Integer, List<INode>> nodesByType = this.getTypeMapping(minDepth, bonus, tree);
        adapter.release();
        adapter.close();
        return nodesByType;
    }

    public Map<Integer, List<INode>> getTypeMapping(int minDepth, int bonus, INgramTree tree) {
        this.logger.info((Object)"Preparing type to node mapping");
        Iterator<INode> nodes = tree.iterateAndRelease();
        HashMap<Integer, List<INode>> nodesByType = new HashMap<Integer, List<INode>>();
        while (nodes.hasNext()) {
            INode node = nodes.next();
            if (node.getDepth() <= 0 || !node.isBranching()) continue;
            ArrayList<Node> list = (ArrayList<Node>)nodesByType.get(node.getValue());
            if (list == null) {
                list = new ArrayList<Node>();
                nodesByType.put(node.getValue(), list);
            }
            if (node.getDepth() < minDepth) {
                int depth = node.getDepth();
                if (depth + bonus < minDepth) continue;
                Node newNode = new Node(node.getValue(), node.getDepth());
                newNode.setBranching(true);
                int requiredDepth = node.getDepth() - 1;
                Collection<IPosition> referencedPositions = node.getReferencedPositions();
                for (IPosition pp : referencedPositions) {
                    if (pp.getElementIndex() != requiredDepth) continue;
                    newNode.addPosition(pp);
                }
                list.add(newNode);
                continue;
            }
            Node copy = new Node(node.getValue(), node.getDepth());
            copy.setPositions(node.getReferencedPositions());
            copy.setBranching(true);
            list.add(copy);
        }
        tree = null;
        return nodesByType;
    }

    public boolean cancelled() {
        return super.cancelled();
    }

    public void setSequences(ArrayList<int[]> sequences) {
        this.sequenceMatrix = sequences;
    }
}

