/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl;

import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IAlignedSequence;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IMatch;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.ContextPosition;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.ContextPositionList;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.Match;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class AlignedSequence
implements IAlignedSequence,
Externalizable {
    private static final long serialVersionUID = -2757493163971413374L;
    private ContextPositionList[] otherStarts;
    private ContextPositionList[] otherEnds;
    private int sequenceId;
    private short length;
    private List<Annotation<IAnchoredElement>> sequence;
    private long id;
    private transient Map<Integer, Map<Integer, TreeMap<Short, ContextPosition>>> endsCache;

    public AlignedSequence() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.sequenceId);
        out.writeShort(this.length);
        out.writeLong(this.id);
        out.writeInt(this.otherStarts.length);
        int i = 0;
        while (i < this.otherStarts.length) {
            out.writeBoolean(this.otherStarts[i] != null);
            if (this.otherStarts[i] != null) {
                this.otherStarts[i].writeExternal(out);
            }
            ++i;
        }
        out.writeInt(this.otherEnds.length);
        i = 0;
        while (i < this.otherEnds.length) {
            out.writeBoolean(this.otherEnds[i] != null);
            if (this.otherEnds[i] != null) {
                this.otherEnds[i].writeExternal(out);
            }
            ++i;
        }
        out.writeInt(this.sequence.size());
        for (Annotation<IAnchoredElement> anno : this.sequence) {
            anno.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sequenceId = in.readInt();
        this.length = in.readShort();
        this.id = in.readLong();
        int length = in.readInt();
        this.otherStarts = new ContextPositionList[length];
        int i = 0;
        while (i < length) {
            if (in.readBoolean()) {
                this.otherStarts[i] = new ContextPositionList();
                this.otherStarts[i].readExternal(in);
            }
            ++i;
        }
        length = in.readInt();
        this.otherEnds = new ContextPositionList[length];
        i = 0;
        while (i < length) {
            if (in.readBoolean()) {
                this.otherEnds[i] = new ContextPositionList();
                this.otherEnds[i].readExternal(in);
            }
            ++i;
        }
        length = in.readInt();
        this.sequence = new ArrayList<Annotation<IAnchoredElement>>(length);
        i = 0;
        while (i < length) {
            Annotation anno = new Annotation();
            anno.readExternal(in);
            this.sequence.add((Annotation<IAnchoredElement>)anno);
            ++i;
        }
    }

    public AlignedSequence(int id, int length) {
        this.sequenceId = id;
        this.length = (short)length;
        this.otherStarts = new ContextPositionList[length];
        this.otherEnds = new ContextPositionList[length];
    }

    public void trimStartNodes() {
        ContextPositionList[] contextPositionListArray = this.otherStarts;
        int n = this.otherStarts.length;
        int n2 = 0;
        while (n2 < n) {
            ContextPositionList list = contextPositionListArray[n2];
            if (list != null) {
                list.trim();
            }
            ++n2;
        }
    }

    public void trimEndNodes() {
        ContextPositionList[] contextPositionListArray = this.otherEnds;
        int n = this.otherEnds.length;
        int n2 = 0;
        while (n2 < n) {
            ContextPositionList list = contextPositionListArray[n2];
            if (list != null) {
                list.trim();
            }
            ++n2;
        }
    }

    public ContextPositionList[] getStartPositions() {
        return this.otherStarts;
    }

    public ContextPositionList[] getEndPositions() {
        return this.otherEnds;
    }

    public void release() {
        if (this.endsCache != null) {
            this.endsCache.clear();
            this.endsCache = null;
        }
    }

    private Map<Integer, TreeMap<Short, ContextPosition>> getStartsFor(int start) {
        ContextPositionList starts = this.otherStarts[start];
        Iterator<ContextPosition> startIterator = starts.iterator();
        HashMap<Integer, TreeMap<Short, ContextPosition>> startHypotheses = new HashMap<Integer, TreeMap<Short, ContextPosition>>();
        while (startIterator.hasNext()) {
            ContextPosition startHypothesis = startIterator.next();
            TreeMap<Short, ContextPosition> map = (TreeMap<Short, ContextPosition>)startHypotheses.get(startHypothesis.sequence());
            if (map == null) {
                map = new TreeMap<Short, ContextPosition>();
                startHypotheses.put(startHypothesis.sequence(), map);
            }
            map.put(startHypothesis.wordPos(), startHypothesis);
        }
        return startHypotheses;
    }

    private Map<Integer, TreeMap<Short, ContextPosition>> getEndsFor(int end) {
        if (this.endsCache == null) {
            this.endsCache = new HashMap<Integer, Map<Integer, TreeMap<Short, ContextPosition>>>();
        } else {
            Map<Integer, TreeMap<Short, ContextPosition>> cached = this.endsCache.get(end);
            if (cached != null) {
                return cached;
            }
        }
        ContextPositionList ends = this.otherEnds[end];
        HashMap<Integer, TreeMap<Short, ContextPosition>> endHypotheses = new HashMap<Integer, TreeMap<Short, ContextPosition>>();
        for (ContextPosition endHypothesis : ends) {
            TreeMap<Short, ContextPosition> map = (TreeMap<Short, ContextPosition>)endHypotheses.get(endHypothesis.sequence());
            if (map == null) {
                map = new TreeMap<Short, ContextPosition>();
                endHypotheses.put(endHypothesis.sequence(), map);
            }
            map.put(endHypothesis.wordPos(), endHypothesis);
        }
        this.endsCache.put(end, endHypotheses);
        return endHypotheses;
    }

    @Override
    public List<IMatch> getMatches(int start, int end) {
        ContextPositionList startPosition = this.otherStarts[start];
        Map<Integer, TreeMap<Short, ContextPosition>> ends = this.getEndsFor(end);
        Iterator<ContextPosition> starts = startPosition.iterator();
        ArrayList<IMatch> candidates = new ArrayList<IMatch>(256);
        while (starts.hasNext()) {
            NavigableMap<Short, ContextPosition> wordCandidates;
            ContextPosition sp = starts.next();
            TreeMap<Short, ContextPosition> sequenceCandidates = ends.get(sp.sequence());
            if (sequenceCandidates == null || (wordCandidates = sequenceCandidates.tailMap(sp.wordPos(), false)).isEmpty()) continue;
            for (ContextPosition ep : wordCandidates.values()) {
                Match ms = new Match(sp, ep);
                candidates.add(ms);
            }
        }
        return candidates;
    }

    @Override
    public List<IMatch> getSingleEndMatches(int end, List<int[]> sequenceMatrix) {
        return this.acceptFromSequenceStartToIndex(this.getEndsFor(end));
    }

    @Override
    public List<IMatch> getSingleStartMatches(int start, List<int[]> sequenceMatrix) {
        return this.acceptFromIndexToSequenceEnd(this.getStartsFor(start), sequenceMatrix);
    }

    private List<IMatch> acceptFromIndexToSequenceEnd(Map<Integer, TreeMap<Short, ContextPosition>> starts, List<int[]> sequenceMatrix) {
        Iterator<Map.Entry<Integer, TreeMap<Short, ContextPosition>>> entries = starts.entrySet().iterator();
        ArrayList<IMatch> matches = new ArrayList<IMatch>();
        while (entries.hasNext()) {
            Map.Entry<Integer, TreeMap<Short, ContextPosition>> entry = entries.next();
            TreeMap<Short, ContextPosition> positions = entry.getValue();
            Set<Map.Entry<Short, ContextPosition>> pSet = positions.entrySet();
            int sequenceId = entry.getKey();
            for (Map.Entry<Short, ContextPosition> hypo : pSet) {
                int wordPos = sequenceMatrix.get(sequenceId).length;
                if (hypo.getValue().wordPos() == wordPos) continue;
                ContextPosition e = new ContextPosition(sequenceId, wordPos, 0);
                matches.add(new Match(hypo.getValue(), e));
            }
        }
        return matches;
    }

    private List<IMatch> acceptFromSequenceStartToIndex(Map<Integer, TreeMap<Short, ContextPosition>> ends) {
        Iterator<Map.Entry<Integer, TreeMap<Short, ContextPosition>>> entries = ends.entrySet().iterator();
        ArrayList<IMatch> matches = new ArrayList<IMatch>();
        while (entries.hasNext()) {
            Map.Entry<Integer, TreeMap<Short, ContextPosition>> entry = entries.next();
            TreeMap<Short, ContextPosition> positions = entry.getValue();
            Set<Map.Entry<Short, ContextPosition>> pSet = positions.entrySet();
            int sequenceId = entry.getKey();
            for (Map.Entry<Short, ContextPosition> hypo : pSet) {
                if (hypo.getValue().wordPos() == -1) continue;
                ContextPosition s = new ContextPosition(sequenceId, -1, 0);
                matches.add(new Match(s, hypo.getValue()));
            }
        }
        return matches;
    }

    public void registerStartHypothesis(IPosition myPosition, Collection<IPosition> sequences, int depth, ArrayList<int[]> sequenceMatrix) {
        this.register(myPosition, sequences, depth, this.otherStarts, sequenceMatrix, true);
    }

    public void registerEndHypothesis(IPosition myPosition, Collection<IPosition> sequences, int depth, ArrayList<int[]> sequenceMatrix) {
        this.register(myPosition, sequences, depth, this.otherEnds, sequenceMatrix, false);
    }

    private void register(IPosition myPosition, Collection<IPosition> sequences, int depth, ContextPositionList[] others, ArrayList<int[]> sequenceMatrix, boolean isSuffix) {
        int mySequence = myPosition.getSequenceIndex();
        ContextPositionList other = others[myPosition.getElementIndex()];
        if (other == null) {
            others[myPosition.getElementIndex()] = other = new ContextPositionList();
        }
        int myType = -1;
        int[] currentSequence = sequenceMatrix.get(mySequence);
        if (isSuffix && currentSequence.length > myPosition.getElementIndex() + 1) {
            myType = currentSequence[myPosition.getElementIndex() + 1];
        }
        if (!isSuffix && myPosition.getElementIndex() > 0) {
            myType = currentSequence[myPosition.getElementIndex() - 1];
        }
        for (IPosition pp : sequences) {
            int[] otherSequence;
            int seqId = pp.getSequenceIndex();
            short wp = pp.getElementIndex();
            if (mySequence == seqId || -1 != myType && (isSuffix ? (otherSequence = sequenceMatrix.get(seqId)).length > wp + 1 && myType == otherSequence[wp + 1] : wp > 0 && myType == (otherSequence = sequenceMatrix.get(seqId))[wp - 1])) continue;
            other.insertOrUpdate(seqId, wp, depth);
        }
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }

    public TreeSet<Short> getStartIndices() {
        TreeSet<Short> set = new TreeSet<Short>();
        int i = 0;
        while (i < this.otherStarts.length) {
            if (this.otherStarts[i] != null) {
                set.add((short)i);
            }
            ++i;
        }
        return set;
    }

    public TreeSet<Short> getEndIndices() {
        TreeSet<Short> set = new TreeSet<Short>();
        int i = 0;
        while (i < this.otherEnds.length) {
            if (this.otherEnds[i] != null) {
                set.add((short)i);
            }
            ++i;
        }
        return set;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    public ContextPositionList getStartsAt(int pos) {
        return this.otherStarts[pos];
    }

    public ContextPositionList getEndsAt(int pos) {
        return this.otherEnds[pos];
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setSequence(List<Annotation<IAnchoredElement>> sequence) {
        this.sequence = sequence;
    }

    @Override
    public List<Annotation<IAnchoredElement>> getWords() {
        return this.sequence;
    }
}

