/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.misc;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.TypeMapping;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.filter.access.IFilterAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.filter.data.IFilter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.access.RangeFilterAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.AnnotationRangeFilter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.Filter;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.uni-koeln.de/space/sschwieb", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="SOG (Analyze)", summary="Generates hypotheses about paradigmatic structures in sequences, based on the length of the shared context of two phrases. A hypothesis is accepted if at least one of the found contexts matches the configured restrictions.", bigO="not so bad, in general", version="1.0", reusableResults=true))
public class FindProperties
extends TeslaComponent {
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", description="The sequences to align (for instance, sentences)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items", description="The items to align (for instance, words)")
    protected IAnchoredElementAccessAdapter<IAnchoredElement> words;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Constituents", description="The sequences to align (for instance, sentences)")
    private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> constituentIn;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.filter.Filter", name="Filters", min=0, max=-1)
    private List<IFilterAccessAdapter<IAnchoredElement, IFilter<IAnchoredElement>>> filters;
    @OutputAdapter(dataObject=Filter.class, name="Filter", type=DefaultTunguskaOutputAdapter.class, accessAdapterImpl=RangeFilterAccessAdapter.class, description="The generated filter, which can be applied on all annotations")
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.filter.Filter")
    private IOutputAdapter<Filter<DataObject>> outputAdapter;
    @Configuration(defaultValue="false", name="Invert matching", min=1, max=1, description="If enabled, an annotation is not accepted if it matches an annotation from 'Filter'. If disabled, an annotation will be accepted if it  matches an annotation from 'Filter'")
    private boolean invertMatching = false;
    private AggregatedResults leftContext = new AggregatedResults();
    private AggregatedResults rightContext = new AggregatedResults();
    private AggregatedResults sentenceLength = new AggregatedResults();
    private AggregatedResults startPosition = new AggregatedResults();
    private AggregatedResults endPosition = new AggregatedResults();
    private AggregatedResults constituentLength = new AggregatedResults();
    private AggregatedResults relativeConstituentsLengths = new AggregatedResults();
    private int overallConstituents = 0;

    @Run
    public Result run() {
        InputIterator signals = this.sequences.getAllSignalIds();
        signals.registerAsProgressBar((ProgressSource)this);
        while (signals.hasNext()) {
            String signalId = (String)signals.next();
            InputIterator sentences = this.sequences.getAnchoredElements(Range.forSignal((String)signalId), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
            AnnotationRangeFilter filter = new AnnotationRangeFilter(this.invertMatching);
            while (sentences.hasNext() && !this.cancelled()) {
                Annotation sentence = (Annotation)sentences.next();
                InputIterator elements = this.words.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
                List wordList = this.asList(elements);
                InputIterator constituents = this.constituentIn.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IGeneralizedHeuristicConstituent.class);
                while (constituents.hasNext() && !this.cancelled()) {
                    Annotation constituent = (Annotation)constituents.next();
                    boolean rewrite = true;
                    for (IFilterAccessAdapter<IAnchoredElement, IFilter<IAnchoredElement>> f : this.filters) {
                        Annotation a;
                        if (f.matches(a = constituent)) continue;
                        rewrite = false;
                        break;
                    }
                    if (!rewrite || !this.accept((Annotation<IGeneralizedHeuristicConstituent>)constituent, (Annotation<IAnchoredElement>)sentence, wordList)) continue;
                    filter.add(constituent);
                }
            }
            Annotation anno = this.outputAdapter.getAnnotationFactory().newSignalAnnotation(signalId, (DataObject)filter, TypeMapping.NONE);
            this.outputAdapter.store(anno);
        }
        try {
            this.leftContext.normalizeValues();
            this.leftContext.toFile("Left Context.txt");
            this.rightContext.normalizeValues();
            this.rightContext.toFile("Right Context.txt");
            this.sentenceLength.normalizeValues();
            this.sentenceLength.toFile("Sentence Length.txt");
            this.startPosition.normalizeValues();
            this.startPosition.toFile("Start Position.txt");
            this.endPosition.normalizeValues();
            this.endPosition.toFile("End Position.txt");
            this.constituentLength.normalizeValues();
            this.constituentLength.toFile("Constituent Length.txt");
            this.relativeConstituentsLengths.normalizeValues();
            this.relativeConstituentsLengths.toFile("Relative Constituent Length.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }

    private boolean accept(Annotation<IGeneralizedHeuristicConstituent> constituent, Annotation<IAnchoredElement> sentence, List<Annotation<IAnchoredElement>> wordList) {
        ++this.overallConstituents;
        IGeneralizedHeuristicConstituent data = (IGeneralizedHeuristicConstituent)constituent.getDataObject();
        double maxLeftContextLength = data.getAverageLeftContextLength();
        this.leftContext.increment((int)(maxLeftContextLength * 100.0));
        double maxRightContextLength = data.getAverageRightContextLength();
        this.rightContext.increment((int)(maxRightContextLength * 100.0));
        int elements = wordList.size();
        this.sentenceLength.increment(elements);
        int constituentStart = 0;
        int i = 0;
        while (i < wordList.size()) {
            if (wordList.get(i).getLeftAnchor() == constituent.getLeftAnchor()) {
                constituentStart = i;
                break;
            }
            ++i;
        }
        int relativeStart = (int)((double)constituentStart / (double)elements * 50.0);
        this.startPosition.increment(relativeStart);
        int constituentEnd = 0;
        int i2 = 0;
        while (i2 < wordList.size()) {
            if (wordList.get(i2).getRightAnchor() == constituent.getRightAnchor()) {
                constituentEnd = i2;
                break;
            }
            ++i2;
        }
        int relativeEnd = (int)((double)constituentEnd / (double)elements * 50.0);
        this.endPosition.increment(relativeEnd);
        this.constituentLength.increment(constituentEnd - constituentStart);
        int relativeConstituentLength = (int)((double)(constituentEnd - constituentStart) / (double)elements * 100.0);
        this.relativeConstituentsLengths.increment(relativeConstituentLength);
        return false;
    }

    class AggregatedResults {
        private Map<Integer, Double> values = new TreeMap<Integer, Double>();

        AggregatedResults() {
        }

        public void increment(int value) {
            Double integer = this.values.get(value);
            if (integer == null) {
                this.values.put(value, 1.0);
            } else {
                this.values.put(value, integer + 1.0);
            }
        }

        public void normalizeValues() {
            double count = 0.0;
            Iterator<Map.Entry<Integer, Double>> iterator = this.values.entrySet().iterator();
            while (iterator.hasNext()) {
                count += iterator.next().getValue().doubleValue();
            }
            for (Map.Entry<Integer, Double> entry : this.values.entrySet()) {
                entry.setValue(entry.getValue() / count * 100.0);
            }
        }

        public void toFile(String string) throws IOException {
            File dir = new File(FindProperties.this.getComponentName());
            dir.mkdirs();
            File file = new File(dir, string);
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            for (Map.Entry<Integer, Double> entry : this.values.entrySet()) {
                bw.write(entry.getKey() + ":" + entry.getValue() + "\n");
            }
            bw.close();
        }
    }
}

