/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.misc;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.access.ISentenceAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.data.ISentence;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.impl.hibernate.data.Sentence;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.impl.tunguska.access.TSentenceTokenAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.phil-fak.uni-koeln.de/sschwieb.html", organization="Department of Computational Linguistics, University of Cologne")}, description=@Description(name="Sentence Rewriter (Old)", summary="A utility component to simplify exchanging corpora", bigO="linear (number of annotations)", reusableResults=true, version="1.0"))
public class SentenceRewriter
extends TeslaComponent {
    @OutputAdapter(dataObject=Sentence.class, type=DefaultTunguskaOutputAdapter.ProtoStuff.class, name="Sentences", accessAdapterImpl=TSentenceTokenAccessAdapter.class)
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.tokenizer.SentenceDetector")
    private IOutputAdapter<Sentence> sentenceOut;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.tokenizer.SentenceDetector", name="Sentences")
    private ISentenceAccessAdapter<ISentence> sentenceIn;

    @Run
    public Result run() {
        InputIterator signals = this.sentenceIn.getAllSignalIds();
        signals.registerAsProgressBar((ProgressSource)this);
        while (signals.hasNext() && !this.cancelled()) {
            String signalId = (String)signals.next();
            InputIterator toConvert = this.sentenceIn.getSentences(Range.forSignal((String)signalId), Order.ORDER_LEFTANCHOR_ASC);
            while (toConvert.hasNext() && !this.cancelled()) {
                Annotation element = (Annotation)toConvert.next();
                Sentence data = new Sentence(((ISentence)element.getDataObject()).isValidSentence());
                Annotation anno = this.sentenceOut.getAnnotationFactory().newAnnotation(element.getLeftAnchor(), element.getRightAnchor(), signalId, (DataObject)data, element.getTypeId());
                this.sentenceOut.store(anno);
            }
        }
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }
}

