/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.misc;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.TypeMapping;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.access.RangeFilterAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.AnnotationRangeFilter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.Filter;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;
import java.util.List;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.uni-koeln.de/space/sschwieb", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="SOG (Filter)", summary="Generates hypotheses about paradigmatic structures in sequences, based on the length of the shared context of two phrases. A hypothesis is accepted if at least one of the found contexts matches the configured restrictions.", bigO="not so bad, in general", version="1.0", reusableResults=true))
public class TestFilter
extends TeslaComponent {
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", description="The sequences to align (for instance, sentences)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items", description="The items to align (for instance, words)")
    protected IAnchoredElementAccessAdapter<IAnchoredElement> words;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Constituents", description="The sequences to align (for instance, sentences)")
    private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> constituentIn;
    @OutputAdapter(dataObject=Filter.class, name="Filter", type=DefaultTunguskaOutputAdapter.class, accessAdapterImpl=RangeFilterAccessAdapter.class, description="The generated filter, which can be applied on all annotations")
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.filter.Filter")
    private IOutputAdapter<Filter<DataObject>> outputAdapter;
    @Configuration(defaultValue="false", name="Invert matching", min=1, max=1, description="If enabled, an annotation is not accepted if it matches an annotation from 'Filter'. If disabled, an annotation will be accepted if it  matches an annotation from 'Filter'")
    private boolean invertMatching = false;

    @Run
    public Result run() {
        InputIterator signals = this.sequences.getAllSignalIds();
        signals.registerAsProgressBar((ProgressSource)this);
        while (signals.hasNext()) {
            String signalId = (String)signals.next();
            InputIterator sentences = this.sequences.getAnchoredElements(Range.forSignal((String)signalId), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
            AnnotationRangeFilter filter = new AnnotationRangeFilter(this.invertMatching);
            while (sentences.hasNext() && !this.cancelled()) {
                Annotation sentence = (Annotation)sentences.next();
                InputIterator elements = this.words.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
                List wordList = this.asList(elements);
                InputIterator constituents = this.constituentIn.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IGeneralizedHeuristicConstituent.class);
                while (constituents.hasNext() && !this.cancelled()) {
                    Annotation constituent = (Annotation)constituents.next();
                    if (!this.accept((Annotation<IGeneralizedHeuristicConstituent>)constituent, (Annotation<IAnchoredElement>)sentence, wordList)) continue;
                    filter.add(constituent);
                }
            }
            Annotation anno = this.outputAdapter.getAnnotationFactory().newSignalAnnotation(signalId, (DataObject)filter, TypeMapping.NONE);
            this.outputAdapter.store(anno);
        }
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }

    private boolean accept(Annotation<IGeneralizedHeuristicConstituent> constituent, Annotation<IAnchoredElement> sentence, List<Annotation<IAnchoredElement>> wordList) {
        IGeneralizedHeuristicConstituent data = (IGeneralizedHeuristicConstituent)constituent.getDataObject();
        double elements = wordList.size();
        double constituentStart = 0.0;
        int i = 0;
        while (i < wordList.size()) {
            if (wordList.get(i).getLeftAnchor() == constituent.getLeftAnchor()) {
                constituentStart = -i;
                break;
            }
            ++i;
        }
        double constituentEnd = 0.0;
        int i2 = 0;
        while (i2 < wordList.size()) {
            if (wordList.get(i2).getRightAnchor() == constituent.getRightAnchor()) {
                constituentEnd = i2;
                break;
            }
            ++i2;
        }
        double randomProbability = (elements - 1.0) * elements / 2.0 - 1.0;
        return false;
    }
}

