/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.misc;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.impl.hibernate.data.Token;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.access.ITokenAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.data.IToken;
import de.uni_koeln.spinfo.tesla.roles.tokenizer.impl.tunguska.access.TTokenizerAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.phil-fak.uni-koeln.de/sschwieb.html", organization="Department of Computational Linguistics, University of Cologne")}, description=@Description(name="Token rewriter (Old)", summary="A utility component to simplify exchanging corpora", bigO="linear (number of annotations)", reusableResults=true, version="1.0"))
public class TokenRewriter
extends TeslaComponent {
    @OutputAdapter(dataObject=Token.class, type=DefaultTunguskaOutputAdapter.ProtoStuff.class, name="Tokens", accessAdapterImpl=TTokenizerAccessAdapter.class)
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.tokenizer.Tokenizer")
    private IOutputAdapter<IToken> wordOut;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.tokenizer.Tokenizer", name="Words")
    private ITokenAccessAdapter<IToken> wordIn;

    @Run
    public Result run() {
        InputIterator signals = this.wordIn.getAllSignalIds();
        signals.registerAsProgressBar((ProgressSource)this);
        try {
            while (signals.hasNext() && !this.cancelled()) {
                String signalId = (String)signals.next();
                InputIterator toConvert = this.wordIn.getTokens(Range.forSignal((String)signalId), Order.ORDER_LEFTANCHOR_ASC);
                while (toConvert.hasNext() && !this.cancelled()) {
                    Annotation element = (Annotation)toConvert.next();
                    IToken data = (IToken)((IToken)element.getDataObject()).getClass().newInstance();
                    Annotation anno = this.wordOut.getAnnotationFactory().newAnnotation(element.getLeftAnchor(), element.getRightAnchor(), signalId, (DataObject)data, element.getTypeId());
                    this.wordOut.store(anno);
                }
            }
        }
        catch (InstantiationException e) {
            return Result.ERROR((Throwable)e);
        }
        catch (IllegalAccessException e) {
            return Result.ERROR((Throwable)e);
        }
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }
}

