/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.misc;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.filter.access.IFilterAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.filter.data.IFilter;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.parser.data.IMultiLabelConstituent;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.hibernate.data.MultiLabelConstituent;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.tunguska.access.TunguskaConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.SignalAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.TabularReport;
import de.uni_koeln.spinfo.tesla.runtime.persistence.TeslaDocument;
import de.uni_koeln.spinfo.tesla.runtime.signal.SignalAccessor;
import de.uni_koeln.spinfo.tesla.runtime.signal.SignalIterator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

@Component(threadMode=ThreadMode.NOT_SUPPORTED, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.phil-fak.uni-koeln.de/sschwieb.html", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="SOG Validator", summary="Recombines the annotations of all consumed adapters.", bigO="unknown", version="1.0", reusableResults=true))
public class Validator
extends TeslaComponent {
    private static final long serialVersionUID = 879812013823937578L;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Validatable")
    private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> sequences;
    @SignalAdapter(signalType=String.class, name="texts")
    private SignalAccessor<String> sa;
    @OutputAdapter(dataObject=MultiLabelConstituent.class, type=DefaultTunguskaOutputAdapter.class, name="Constituents", accessAdapterImpl=TunguskaConstituentAccessAdapter.DefaultTunguskaConstituentAccessAdapter.class, description="All detected constituent hypotheses", bufferSize=20)
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.parser.MultiValueConstituentTagger")
    private IOutputAdapter<IMultiLabelConstituent> constituentOut;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.filter.Filter", name="Filters", min=0, max=-1)
    private List<IFilterAccessAdapter<IAnchoredElement, IFilter<IAnchoredElement>>> filters;
    private SortedMap<Integer, Integer> structureLength = new TreeMap<Integer, Integer>();
    private SortedMap<Integer, Integer> reasonCounter = new TreeMap<Integer, Integer>();
    SortedMap<Integer, Integer> aggregatedRightWidths = new TreeMap<Integer, Integer>();
    SortedMap<Integer, Integer> aggregatedWidthSum = new TreeMap<Integer, Integer>();
    SortedMap<Integer, Integer> aggregatedLeftWidths = new TreeMap<Integer, Integer>();

    @Run
    public Result run() throws Exception {
        SignalIterator signals = this.sa.getSignalIterator();
        signals.registerAsProgressBar((ProgressSource)this);
        int missed = 0;
        int toomany = 0;
        int success = 0;
        int sequenceCounter = 0;
        while (signals.hasNext()) {
            TeslaDocument doc = signals.next();
            String signalId = doc.getId();
            ArrayList toStore = new ArrayList();
            InputIterator allSequences = this.sequences.getAnchoredElements(Range.forSignal((String)signalId), null, IGeneralizedHeuristicConstituent.class);
            while (allSequences.hasNext()) {
                Annotation anno = (Annotation)allSequences.next();
                boolean analyze = true;
                for (IFilterAccessAdapter<IAnchoredElement, IFilter<IAnchoredElement>> filter : this.filters) {
                    Annotation hack;
                    if (filter.matches(hack = anno)) continue;
                    analyze = false;
                    break;
                }
                if (!analyze) continue;
                GeneralizedConstituent gc = (GeneralizedConstituent)anno.getDataObject();
                this.analyze(gc);
                int cfr_ignored_0 = ++sequenceCounter % 100;
            }
            System.out.println(String.valueOf(sequenceCounter) + " sequences, Success: " + success + ", missed: " + missed + ", toomany " + toomany);
            DefaultTunguskaOutputAdapter.sort(toStore);
            for (Annotation anno : toStore) {
                this.constituentOut.store(anno);
            }
        }
        System.out.println(String.valueOf(sequenceCounter) + " sequences, Success: " + success + ", missed: " + missed + ", toomany " + toomany);
        int rows = this.reasonCounter.size();
        TabularReport report = super.newReport("Number of justifications", "The number of justifications found for a hypothesis", rows, 3);
        NumberFormat intFormat = NumberFormat.getIntegerInstance();
        NumberFormat percentFormat = NumberFormat.getNumberInstance();
        report.setColumnLabel(0, "Justifications");
        report.setColumnLabel(1, "Count");
        report.setColumnLabel(2, "Percent", percentFormat);
        Set<Map.Entry<Integer, Integer>> entries = this.reasonCounter.entrySet();
        this.fillReport(report, entries);
        rows = this.structureLength.size();
        report = super.newReport("Structure Length", "Length of the constituent", rows, 3);
        report.setColumnLabel(0, "Length");
        report.setColumnLabel(1, "Count");
        report.setColumnLabel(2, "Percent", percentFormat);
        entries = this.structureLength.entrySet();
        this.fillReport(report, entries);
        this.aggregatedLeftWidths = this.aggregatedLeftWidths.headMap(2500);
        rows = this.aggregatedLeftWidths.size();
        report = super.newReport("Average left ctx width", "Average left ctx width, weighted, multiplied by 100", rows, 3);
        report.setColumnLabel(0, "Length");
        report.setColumnLabel(1, "Count");
        report.setColumnLabel(2, "Percent", percentFormat);
        entries = this.aggregatedLeftWidths.entrySet();
        this.fillReport(report, entries);
        this.aggregatedRightWidths = this.aggregatedRightWidths.headMap(2500);
        rows = this.aggregatedRightWidths.size();
        report = super.newReport("Average right ctx width", "Average right ctx width, weighted, multiplied by 100", rows, 3);
        report.setColumnLabel(0, "Length");
        report.setColumnLabel(1, "Count");
        report.setColumnLabel(2, "Percent", percentFormat);
        entries = this.aggregatedRightWidths.entrySet();
        this.fillReport(report, entries);
        this.aggregatedWidthSum = this.aggregatedWidthSum.headMap(10000);
        rows = this.aggregatedWidthSum.size();
        report = super.newReport("Average shared ctx width", "Average shared ctx width, weighted, multiplied by 100", rows, 3);
        report.setColumnLabel(0, "Length");
        report.setColumnLabel(1, "Count");
        report.setColumnLabel(2, "Percent", percentFormat);
        entries = this.aggregatedWidthSum.entrySet();
        this.fillReport(report, entries);
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }

    protected void fillReport(TabularReport report, Set<Map.Entry<Integer, Integer>> entries) {
        double overall = 0.0;
        for (Map.Entry<Integer, Integer> entry : entries) {
            overall += (double)entry.getValue().intValue();
        }
        int counter = 0;
        for (Map.Entry<Integer, Integer> entry : entries) {
            report.setValue(counter, 0, (Object)entry.getKey());
            report.setValue(counter, 1, (Object)entry.getValue());
            report.setValue(counter, 2, (double)(entry.getValue() * 100) / overall);
            ++counter;
        }
    }

    private void analyze(GeneralizedConstituent hypothesis) {
        TreeMap<Integer, Integer> rightWidths = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> widthSum = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Integer> leftWidths = new TreeMap<Integer, Integer>();
        List<Reason> reasons = hypothesis.getMatchDetails();
        Integer count = (Integer)this.reasonCounter.get(reasons.size());
        if (count == null) {
            this.reasonCounter.put(reasons.size(), 1);
        } else {
            this.reasonCounter.put(reasons.size(), count + 1);
        }
        int length = hypothesis.getEnd() - hypothesis.getStart();
        count = (Integer)this.structureLength.get(length);
        if (count == null) {
            this.structureLength.put(length, 1);
        } else {
            this.structureLength.put(length, count + 1);
        }
        for (Reason reason : reasons) {
            int width = reason.getLeftContextWidth() + reason.getLeftBonus();
            Integer c = (Integer)leftWidths.get(width);
            if (c == null) {
                leftWidths.put(width, 1);
            } else {
                leftWidths.put(width, c + 1);
            }
            width = reason.getRightContextWidth() + reason.getRightBonus();
            c = (Integer)rightWidths.get(width);
            if (c == null) {
                rightWidths.put(width, 1);
            } else {
                rightWidths.put(width, c + 1);
            }
            width = reason.getLeftContextWidth() + reason.getRightContextWidth() + reason.getLeftBonus() + reason.getRightBonus();
            c = (Integer)widthSum.get(width);
            if (c == null) {
                widthSum.put(width, 1);
                continue;
            }
            widthSum.put(width, c + 1);
        }
        double averageRight = 0.0;
        for (Map.Entry entry : rightWidths.entrySet()) {
            averageRight += Math.pow(((Integer)entry.getKey()).intValue(), 2.0) * (double)((Integer)entry.getValue()).intValue();
        }
        int scale = 50;
        int toInsert = (int)(averageRight = averageRight * 100.0 / (double)reasons.size()) / scale * scale;
        Integer value = (Integer)this.aggregatedRightWidths.get(toInsert);
        if (value == null) {
            this.aggregatedRightWidths.put(toInsert, 1);
        } else {
            this.aggregatedRightWidths.put(toInsert, value + 1);
        }
        double averageLeft = 0.0;
        for (Map.Entry entry : rightWidths.entrySet()) {
            averageLeft += Math.pow(((Integer)entry.getKey()).intValue(), 2.0) * (double)((Integer)entry.getValue()).intValue();
        }
        toInsert = (int)(averageLeft = averageLeft * 100.0 / (double)reasons.size()) / scale * scale;
        value = (Integer)this.aggregatedLeftWidths.get(toInsert);
        if (value == null) {
            this.aggregatedLeftWidths.put(toInsert, 1);
        } else {
            this.aggregatedLeftWidths.put(toInsert, value + 1);
        }
        double averageSum = 0.0;
        for (Map.Entry entry : widthSum.entrySet()) {
            averageSum += Math.pow(((Integer)entry.getKey()).intValue(), 2.0) * (double)((Integer)entry.getValue()).intValue();
        }
        toInsert = (int)(averageSum = averageSum * 100.0 / (double)reasons.size()) / scale * scale;
        value = (Integer)this.aggregatedWidthSum.get(toInsert);
        if (value == null) {
            this.aggregatedWidthSum.put(toInsert, 1);
        } else {
            this.aggregatedWidthSum.put(toInsert, value + 1);
        }
    }
}

