/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INgramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.Node;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.PosPair;
import de.uni_koeln.spinfo.tesla.component.util.GoogleHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class NGramTree
implements INgramTree {
    private static final long serialVersionUID = -6595784693922413177L;
    public static final int TERMINATE = -2;
    protected final Node root = new Node(-1, 0);
    private int maxDepth;
    private long id;

    public NGramTree() {
    }

    public NGramTree(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public Node getRoot() {
        return this.root;
    }

    public void insert(int[] sequence, int id, boolean reverse) {
        Node searchDummy = new Node(Integer.MAX_VALUE, 0);
        int[] path = sequence;
        if (reverse) {
            path = this.flip(path);
        }
        int i = 0;
        while (i < path.length) {
            Node current = this.root;
            int steps = 0;
            int j = i;
            while (j < path.length) {
                current = current.append(path[j], id, (short)j, searchDummy, this);
                if (++steps == this.maxDepth) break;
                ++j;
            }
            current.append(-2, id, (short)255, searchDummy, null);
            ++i;
        }
    }

    private int[] flip(int[] path) {
        int[] reverse = new int[path.length];
        int i = 0;
        while (i < reverse.length) {
            reverse[i] = path[path.length - i - 1];
            ++i;
        }
        return reverse;
    }

    public void printTree() {
        this.print(this.root);
        System.out.println();
    }

    private void print(INode current) {
        System.out.println(String.valueOf(current.getValue()) + ", Depth " + current.getDepth());
        Set<INode> children = current.getChildren();
        if (children == null) {
            return;
        }
        for (INode node : children) {
            this.print(node);
        }
    }

    @Override
    public Iterator<INode> iterateAndRelease() {
        return new NodeIterator(this.root);
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public int getNumberOfNodes() {
        return this.count(this.root);
    }

    private int count(Node node) {
        if (node.getChildren() == null) {
            return 1;
        }
        int subTree = 1;
        Set children = node.getChildren();
        for (INode iNode : children) {
            subTree += this.count((Node)iNode);
        }
        return subTree;
    }

    public void reversePositions(ArrayList<int[]> sequenceMatrix) {
        this.reverse(this.root, sequenceMatrix);
    }

    private void reverse(Node current, ArrayList<int[]> sequenceMatrix) {
        Set children = current.getChildren();
        if (children != null) {
            for (INode child : children) {
                this.reverse((Node)child, sequenceMatrix);
            }
        }
        List<IPosition> reverse = this.reverse(current.getReferencedPositions(), sequenceMatrix);
        current.setPositions(reverse);
    }

    private List<IPosition> reverse(Collection<IPosition> positions, ArrayList<int[]> sequenceMatrix) {
        ArrayList<IPosition> reverse = new ArrayList<IPosition>(positions.size());
        for (IPosition posPair : positions) {
            PosPair rev = PosPair.newPair(posPair.getSequenceIndex(), (short)(sequenceMatrix.get(posPair.getSequenceIndex()).length - posPair.getElementIndex() - 1));
            reverse.add(rev);
        }
        reverse.trimToSize();
        return reverse;
    }

    public void trim() {
        this.trim(this.root);
    }

    private void trim(Node current) {
        Set children = current.getChildren();
        if (children != null) {
            for (INode child : children) {
                this.trim((Node)child);
            }
        }
        ArrayList<IPosition> trimmed = new ArrayList<IPosition>(current.getReferencedPositions());
        current.setPositions(trimmed);
    }

    class NodeIterator
    implements Iterator<INode> {
        private Node toReturn;

        public NodeIterator(Node root) {
            this.findNext(root);
        }

        public void findNext(Node current) {
            if (current == null) {
                this.toReturn = null;
                return;
            }
            Node next = current;
            while (next.getChildren() != null && ((GoogleHashSet)next.getChildren()).size() > 0) {
                next = (Node)((GoogleHashSet)next.getChildren()).iterator().next();
            }
            this.toReturn = next;
            this.toReturn.updateBranching();
        }

        @Override
        public boolean hasNext() {
            return this.toReturn != null;
        }

        @Override
        public Node next() {
            Node node = this.toReturn;
            this.toReturn.clearChildren();
            Node parent = this.toReturn.getParent();
            if (parent != null) {
                parent.updateBranching();
                ((GoogleHashSet)parent.getChildren()).remove(this.toReturn);
            }
            this.findNext(parent);
            return node;
        }

        @Override
        public void remove() {
        }
    }
}

