/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.NGramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.PosPair;
import de.uni_koeln.spinfo.tesla.component.util.GoogleHashSet;
import java.io.Serializable;
import java.util.Collection;

public class Node
implements Comparable<Node>,
INode,
Serializable {
    private static final long serialVersionUID = 8718427149468641624L;
    private GoogleHashSet<Node> children;
    private int value;
    private final byte depth;
    private Collection<IPosition> sequences = new GoogleHashSet<IPosition>();
    private Node parent;
    private int id;
    private static final byte NOT_SET = 0;
    private static final byte YES = 1;
    private static final byte NO = 2;
    private static final int posMask = 255;
    private byte branching = 0;
    private static int nextId = 0;

    public Node(int value, int depth) {
        this.value = value;
        this.depth = (byte)(depth - 127);
        this.id = nextId++;
    }

    public static int encode(int sequenceId, int wordPos) {
        return sequenceId << 8 | wordPos & 0xFF;
    }

    public static PosPair decode(int value) {
        int s = value >> 8;
        int w = value & 0xFF;
        return PosPair.newPair(s, (short)w);
    }

    public static int sequence(int value) {
        return value >> 8;
    }

    public synchronized Node append(int value, int sequenceId, short wordPos, Node searchDummy, NGramTree tree) {
        if (this.children == null) {
            this.children = new GoogleHashSet();
        }
        searchDummy.value = value;
        Node child = (Node)this.children.get(searchDummy);
        if (child == null) {
            child = new Node(value, this.getDepth() + 1);
            child.parent = this;
            this.children.add(child);
        }
        child.sequences.add(new PosPair(sequenceId, wordPos));
        return child;
    }

    @Override
    public Node getParent() {
        return this.parent;
    }

    public int hashCode() {
        return this.value * 1023;
    }

    public boolean equals(Object obj) {
        return this.value == ((Node)obj).value;
    }

    public GoogleHashSet<INode> getChildren() {
        GoogleHashSet<INode> c = this.children;
        return c;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public Collection<IPosition> getReferencedPositions() {
        return this.sequences;
    }

    @Override
    public int compareTo(Node o) {
        return this.value - o.value;
    }

    public String toString() {
        return "Node " + this.value + "/" + this.getDepth() + "(" + this.sequences + ")";
    }

    @Override
    public int getDepth() {
        return 127 + this.depth;
    }

    public void clearSequenceMap() {
        if (this.sequences == null) {
            return;
        }
        this.sequences.clear();
        this.sequences = null;
    }

    public void clearChildren() {
        if (this.children == null) {
            return;
        }
        this.children.clear();
        this.children = null;
    }

    public void updateBranching() {
        if (this.branching == 0) {
            this.branching = this.children == null || this.children.size() < 2 ? (byte)2 : (byte)1;
        }
    }

    @Override
    public boolean isBranching() {
        return this.branching == 1;
    }

    public void setBranching(boolean branching) {
        this.branching = branching ? (byte)1 : (byte)2;
    }

    public void addPosition(IPosition position) {
        this.sequences.add(position);
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setPositions(Collection<IPosition> others) {
        this.sequences = others;
    }

    public void setParent(Node parent) {
        this.parent = parent;
    }
}

