/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.JustifiedHypothesis;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Categorizer {
    public static final String UNIQUE = "Unique";
    public static final String CONSTITUENT = "Constituent";
    public static final String RIGHT_CONTEXT = "Right Context";
    public static final String LEFT_CONTEXT = "Left Context";
    public static final String BOTH_CONTEXTS = "Both Contexts";
    private final String categorizeMethod;
    private final Map<Long, String> ntMap = new HashMap<Long, String>();
    private long nextMapping = 1L;

    public Categorizer(String categorizeMethod) {
        this.categorizeMethod = categorizeMethod;
    }

    private synchronized String getNt(long nt) {
        String label = this.ntMap.get(nt);
        if (label == null) {
            label = String.valueOf(this.ntMap.size() + 1);
            this.ntMap.put(nt, label);
        }
        return label;
    }

    public void categorize(JustifiedHypothesis constituent, GeneralizedConstituent data, List<Annotation<IAnchoredElement>> words, int firstIncluded, int firstNotIncluded, int maxLeft, int maxRight) {
        int i;
        long mapping = 1L;
        if (BOTH_CONTEXTS.equals(this.categorizeMethod) || LEFT_CONTEXT.equals(this.categorizeMethod)) {
            mapping *= 31L;
            if (firstIncluded == 0) {
                mapping *= 31L;
            }
            i = Math.max((int)((double)firstIncluded - constituent.getAverageLeft()), 0);
            while (i < firstIncluded) {
                mapping = mapping * 31L + words.get(i).getTypeId();
                ++i;
            }
        }
        if (BOTH_CONTEXTS.equals(this.categorizeMethod) || RIGHT_CONTEXT.equals(this.categorizeMethod)) {
            mapping *= 31L;
            if (firstNotIncluded == words.size()) {
                mapping *= 31L;
            }
            i = firstNotIncluded;
            while (i < (int)((double)firstNotIncluded + constituent.getAverageRight()) && i < words.size()) {
                mapping = mapping * 31L + words.get(i).getTypeId();
                ++i;
            }
        }
        if (UNIQUE.equals(this.categorizeMethod)) {
            mapping = this.nextMapping++;
        }
        if (CONSTITUENT.equals(this.categorizeMethod)) {
            i = constituent.getLeft();
            while (i < constituent.getRight()) {
                mapping = mapping * 31L + words.get(i).getTypeId();
                ++i;
            }
        }
        data.addCategory(this.getNt(mapping));
    }
}

