/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms;

import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IAlignedSequence;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IMatch;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.AlignedSequence;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.ContextPosition;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.Match;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.JustifiedHypothesis;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.component.test.TestReasonList;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class GlobalAlignmentDetector {
    private final boolean alwaysAddHypothesisToSequenceEnd;
    private final boolean alwaysAddHypothesisFromSequenceStart;
    private boolean excludeEmpty = true;
    private boolean excludeEmptyReason = false;
    private ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix;
    private ArrayList<int[]> sequenceMatrix;

    public GlobalAlignmentDetector(boolean alwaysAddStart, boolean alwaysAddEnd, ArrayList<int[]> sequenceMatrix, ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix) {
        this.alwaysAddHypothesisToSequenceEnd = alwaysAddStart;
        this.alwaysAddHypothesisFromSequenceStart = alwaysAddEnd;
        this.dataMatrix = dataMatrix;
        this.sequenceMatrix = sequenceMatrix;
    }

    public List<Reason> getReasons(List<IMatch> matches, int forbiddenStartType, int forbiddenEndType, int startBonus, int endBonus) {
        ArrayList<Reason> reasons = new ArrayList<Reason>(256);
        if (this.dataMatrix == null) {
            System.out.println("Assuming debug mode - returning patched list (fix this!)");
            return new TestReasonList(matches);
        }
        for (IMatch match : matches) {
            List<Annotation<IAnchoredElement>> sequence = this.dataMatrix.get(match.sequence());
            ContextPosition start = match.start();
            ContextPosition end = match.end();
            try {
                Reason r;
                Annotation<IAnchoredElement> anchor;
                if (start.wordPos() == sequence.size() - 1) {
                    anchor = sequence.get(end.wordPos() - 1);
                    r = new Reason();
                    r.setSequence(match.sequence());
                    r.setFrom(anchor.getRightAnchor());
                    r.setTo(anchor.getRightAnchor());
                    r.setLeftContextWidth(start.getContextLength());
                    r.setRightContextWidth(end.getContextLength());
                    this.updateStartEndBonus(startBonus, endBonus, start, end, r);
                    reasons.add(r);
                    continue;
                }
                if (end.wordPos() == 0) {
                    anchor = sequence.get(0);
                    r = new Reason();
                    r.setSequence(match.sequence());
                    r.setFrom(anchor.getLeftAnchor());
                    r.setTo(anchor.getLeftAnchor());
                    r.setLeftContextWidth(start.getContextLength());
                    r.setRightContextWidth(end.getContextLength());
                    this.updateStartEndBonus(startBonus, endBonus, start, end, r);
                    reasons.add(r);
                    continue;
                }
                Annotation<IAnchoredElement> leftAnchor = sequence.get(start.wordPos() + 1);
                Annotation<IAnchoredElement> rightAnchor = sequence.get(end.wordPos() - 1);
                if (leftAnchor.getLeftAnchor() >= rightAnchor.getRightAnchor() && this.excludeEmptyReason) continue;
                Reason r2 = new Reason();
                r2.setSequence(match.sequence());
                r2.setFrom(leftAnchor.getLeftAnchor());
                r2.setTo(rightAnchor.getRightAnchor());
                r2.setLeftContextWidth(start.getContextLength());
                r2.setRightContextWidth(end.getContextLength());
                this.updateStartEndBonus(startBonus, endBonus, start, end, r2);
                if (!this.accept(match.start(), match.end(), forbiddenStartType, forbiddenEndType)) continue;
                reasons.add(r2);
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        reasons.trimToSize();
        return reasons;
    }

    protected void updateStartEndBonus(int startBonus, int endBonus, ContextPosition start, ContextPosition end, Reason r) {
        int max;
        int pos;
        if (startBonus > 0 && start.wordPos() + 1 - start.getContextLength() <= 0) {
            r.setLeftBonus(startBonus);
        }
        if (endBonus > 0 && (pos = end.wordPos() - 1 + end.getContextLength()) >= (max = this.sequenceMatrix.get(end.sequence()).length - 1)) {
            r.setRightBonus(endBonus);
        }
    }

    private boolean accept(ContextPosition start, ContextPosition end, int forbiddenStartType, int forbiddenEndType) {
        int startType = this.sequenceMatrix.get(start.sequence())[start.wordPos() + 1];
        int endType = this.sequenceMatrix.get(end.sequence())[end.wordPos() - 1];
        return startType != forbiddenStartType && endType != forbiddenEndType;
    }

    public Collection<JustifiedHypothesis> analyzeSequence(IAlignedSequence sequence, int startBonus, int endBonus) {
        JustifiedHypothesis hypothesis;
        SortedSet<Short> startIndices = sequence.getStartIndices();
        SortedSet<Short> endIndices = sequence.getEndIndices();
        TreeSet<JustifiedHypothesis> hypotheses = new TreeSet<JustifiedHypothesis>(new Comparator<JustifiedHypothesis>(){

            @Override
            public int compare(JustifiedHypothesis o1, JustifiedHypothesis o2) {
                int start = o1.getLeft() - o2.getLeft();
                if (start == 0) {
                    return o1.getRight() - o2.getRight();
                }
                return start;
            }
        });
        for (Short start : startIndices) {
            int[] seq;
            int forbiddenEnd;
            int forbiddenStart;
            List<Reason> reasons;
            SortedSet<Short> endings = endIndices.tailSet(start);
            for (Short end : endings) {
                int forbiddenEnd2;
                List<IMatch> matches;
                if (end == start || this.excludeEmpty && start == end - 1 || (matches = sequence.getMatches(start.shortValue(), end.shortValue())).size() == 0) continue;
                hypothesis = new JustifiedHypothesis(sequence.getSequenceId(), (short)(start + 1), end.shortValue());
                int forbiddenStart2 = this.sequenceMatrix.get(sequence.getSequenceId())[start + 1];
                List<Reason> reasons2 = this.getReasons(matches, forbiddenStart2, forbiddenEnd2 = this.sequenceMatrix.get(sequence.getSequenceId())[end - 1], startBonus, endBonus);
                if (reasons2.isEmpty()) continue;
                hypothesis.setReasons(reasons2);
                hypotheses.add(hypothesis);
            }
            if (!this.alwaysAddHypothesisToSequenceEnd) continue;
            if (this.excludeEmpty && start + 1 == sequence.getLength()) break;
            List<IMatch> matches = sequence.getSingleStartMatches(start.shortValue(), this.sequenceMatrix);
            if (matches.isEmpty() || (reasons = this.getReasons(matches, forbiddenStart = this.sequenceMatrix.get(sequence.getSequenceId())[start + 1], forbiddenEnd = (seq = this.sequenceMatrix.get(sequence.getSequenceId()))[seq.length - 1], startBonus, endBonus)).isEmpty()) continue;
            JustifiedHypothesis hypothesis2 = new JustifiedHypothesis(sequence.getSequenceId(), start + 1, sequence.getLength());
            hypothesis2.setReasons(reasons);
            hypotheses.add(hypothesis2);
        }
        if (this.alwaysAddHypothesisFromSequenceStart) {
            for (Short end : endIndices) {
                int forbiddenEnd;
                int forbiddenStart;
                List<Reason> reasons;
                List<IMatch> matches;
                if (this.excludeEmpty && end == 0 || (matches = sequence.getSingleEndMatches(end.shortValue(), this.sequenceMatrix)).isEmpty() || (reasons = this.getReasons(matches, forbiddenStart = this.sequenceMatrix.get(sequence.getSequenceId())[0], forbiddenEnd = this.sequenceMatrix.get(sequence.getSequenceId())[end - 1], startBonus, endBonus)).isEmpty()) continue;
                hypothesis = new JustifiedHypothesis(sequence.getSequenceId(), 0, end.shortValue());
                hypothesis.setReasons(reasons);
                hypotheses.add(hypothesis);
            }
        }
        if (sequence instanceof AlignedSequence) {
            ((AlignedSequence)sequence).release();
        }
        return hypotheses;
    }

    class MultiHypothesis {
        private TreeMap<Integer, TreeSet<Match>> matches = new TreeMap();

        MultiHypothesis() {
        }

        public void add(Match match) {
            TreeSet<Match> set = this.matches.get(match.sequence());
            if (set == null) {
                set = new TreeSet();
                this.matches.put(match.sequence(), set);
            }
            set.add(match);
        }

        public boolean foundMatches() {
            return this.matches.size() > 0;
        }
    }
}

