/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IAnnotationFactory;
import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.TypeMapping;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.access.IAlignedSequenceAccessAdapter;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IAlignedSequence;
import de.uni_koeln.spinfo.tesla.component.paradigms.Categorizer;
import de.uni_koeln.spinfo.tesla.component.paradigms.GlobalAlignmentDetector;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.JustifiedHypothesis;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.component.util.MatrixLoader;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.tunguska.access.TunguskaConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ChoiceRestriction;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@Component(threadMode=ThreadMode.CUSTOM, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.uni-koeln.de/space/sschwieb", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="SOG (Select)", summary="", bigO="l", version="1.0", reusableResults=true))
public class HypothesisEvaluator
extends TeslaComponent {
    private static final long serialVersionUID = 1214407936563L;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.AlignmentHypothesisGenerator", name="Hypotheses", description="The alignment hypotheses")
    private IAlignedSequenceAccessAdapter<IAlignedSequence> hypotheses;
    @OutputAdapter(dataObject=GeneralizedConstituent.class, type=DefaultTunguskaOutputAdapter.ProtoStuff.class, name="Constituents", accessAdapterImpl=TunguskaConstituentAccessAdapter.DefaultTunguskaConstituentAccessAdapter.class, description="All constituents detected by the parser")
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector")
    private IOutputAdapter<GeneralizedConstituent> out;
    @Configuration(name="Categorization", description="This parameter defines how categories will be defined to constituents. 'Unique' will generate a new category for each constituent. 'Constituent' will assign the same category to two constituents if they refer to annotations of the same type. 'Left Context' will assign the same category to  all constituents which share the same left context.\n'Right Context' will assign the same category to all constituents which share the same right context.\n'Both Contexts' will assign the same category to all constituents which have the same left and right contexts in common. ", editor="de.uni_koeln.spinfo.tesla.client.ui.editors.form.configurations.itemeditors.ChoiceEditor", defaultValue="Both Contexts", restriction=ChoiceRestriction.class, editorConfiguration={"Both Contexts", "Left Context", "Right Context", "Constituent", "Unique"})
    private String categorizeMethod = "Both Contexts";
    @Configuration(name="Include sequence start", defaultValue="true")
    private boolean alwaysAddStart = true;
    @Configuration(name="Include sequence end", defaultValue="true")
    private boolean alwaysAddEnd = true;
    @Configuration(name="Sequence Start Weight", defaultValue="1")
    private int sentenceStart = 1;
    @Configuration(name="Sequence End Weight", defaultValue="1")
    private int sentenceEnd = 1;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", description="")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items", description="")
    private IAnchoredElementAccessAdapter<IAnchoredElement> words;
    private Categorizer categorizer;

    @Run
    public Result run() throws Exception {
        this.categorizer = new Categorizer(this.categorizeMethod);
        InputIterator<Annotation<IAlignedSequence>> allSequences = this.hypotheses.getAlignedSequences();
        this.setProgressName("Loading data...");
        MatrixLoader ml = new MatrixLoader();
        InputIterator signals = this.words.getAllSignalIds();
        ArrayList<String> signalIds = new ArrayList<String>();
        while (signals.hasNext()) {
            signalIds.add((String)signals.next());
        }
        ArrayList<int[]> sequenceMatrix = ml.loadData(signalIds, this, this.sequences, this.words, 20.0);
        double step = 95.0 / (double)sequenceMatrix.size();
        double current = 5.0;
        ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix = ml.getDataMatrix();
        ml.release();
        this.setProgress((int)current);
        this.logger.info((Object)"Creating hypotheses...");
        GlobalAlignmentDetector detector = new GlobalAlignmentDetector(this.alwaysAddStart, this.alwaysAddEnd, sequenceMatrix, dataMatrix);
        int counter = 0;
        int threads = Math.max(2, Runtime.getRuntime().availableProcessors());
        ExecutorService executors = Executors.newFixedThreadPool(threads);
        ArrayList<ProcessCallable> pool = new ArrayList<ProcessCallable>(threads);
        int i = 0;
        while (i < threads) {
            pool.add(new ProcessCallable(detector));
            ++i;
        }
        ArrayList<ProcessCallable> callables = new ArrayList<ProcessCallable>(threads);
        ArrayList<Future<List<Annotation<GeneralizedConstituent>>>> results = new ArrayList<Future<List<Annotation<GeneralizedConstituent>>>>();
        int next = 0;
        while (allSequences.hasNext() && !this.cancelled()) {
            Annotation sequence = (Annotation)allSequences.next();
            ProcessCallable callable = (ProcessCallable)pool.get(next++);
            callable.setSequence((Annotation<IAlignedSequence>)sequence);
            callables.add(callable);
            results.add(executors.submit(callable));
            if (next == threads) {
                next = this.store(callables, results);
            }
            if (++counter % 1000 == 0) {
                this.logger.info((Object)("Analyzed " + counter + " sequences."));
            }
            this.setProgress((int)(current += step));
        }
        executors.shutdown();
        this.store(callables, results);
        this.logger.info((Object)("Processed " + counter + " sequences."));
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }

    protected int store(List<ProcessCallable> callables, List<Future<List<Annotation<GeneralizedConstituent>>>> results) throws InterruptedException, ExecutionException {
        for (Future<List<Annotation<GeneralizedConstituent>>> result : results) {
            List<Annotation<GeneralizedConstituent>> toStore = result.get();
            for (Annotation<GeneralizedConstituent> anno : toStore) {
                this.out.store(anno);
            }
        }
        int next = 0;
        callables.clear();
        results.clear();
        return next;
    }

    class ProcessCallable
    implements Callable<List<Annotation<GeneralizedConstituent>>> {
        private final GlobalAlignmentDetector detector;
        private Annotation<IAlignedSequence> sequence;

        public ProcessCallable(GlobalAlignmentDetector detector) {
            this.detector = detector;
        }

        public void setSequence(Annotation<IAlignedSequence> sequence) {
            this.sequence = sequence;
        }

        @Override
        public List<Annotation<GeneralizedConstituent>> call() throws Exception {
            Collection<JustifiedHypothesis> hypotheses = this.detector.analyzeSequence((IAlignedSequence)this.sequence.getDataObject(), HypothesisEvaluator.this.sentenceStart, HypothesisEvaluator.this.sentenceEnd);
            Iterator<JustifiedHypothesis> iterator = hypotheses.iterator();
            List<Annotation<IAnchoredElement>> words = ((IAlignedSequence)this.sequence.getDataObject()).getWords();
            ArrayList<Annotation<GeneralizedConstituent>> toStore = new ArrayList<Annotation<GeneralizedConstituent>>();
            IAnnotationFactory factory = HypothesisEvaluator.this.out.getAnnotationFactory();
            while (iterator.hasNext()) {
                JustifiedHypothesis constituent = iterator.next();
                GeneralizedConstituent data = new GeneralizedConstituent(constituent.getLeft(), constituent.getRight(), (int)constituent.getAverageLeft(), (int)constituent.getAverageRight(), (short)words.size());
                List<Reason> reasons = constituent.getReasons();
                data.addContextDetails(reasons);
                int lastIncluded = constituent.getRight() - 1;
                short left = constituent.getLeft();
                Annotation anno = factory.newAnnotation(words.get(constituent.getLeft()).getLeftAnchor(), words.get(lastIncluded).getRightAnchor(), words.get(0).getSignalId(), (DataObject)data, TypeMapping.SELF_GENERATED);
                HypothesisEvaluator.this.categorizer.categorize(constituent, data, words, left, constituent.getRight(), (int)constituent.getAverageLeft(), (int)constituent.getAverageRight());
                toStore.add((Annotation<GeneralizedConstituent>)anno);
                iterator.remove();
            }
            return toStore;
        }
    }
}

