/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.data.impl;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.hibernate.data.MultiLabelConstituent;
import java.util.ArrayList;
import java.util.List;

public class GeneralizedConstituent
extends MultiLabelConstituent
implements IGeneralizedHeuristicConstituent {
    private static final long serialVersionUID = -248098513899278750L;
    private int startPos;
    private int endPos;
    private int sentenceLength;
    private int rightContexts;
    private int leftContexts;
    private int matches;
    private int matchingSequences;
    private int overallSequences;
    private List<Reason> matchDetails = new ArrayList<Reason>();

    public GeneralizedConstituent(int start, int end, int maxLeft, int maxRight, int sentenceLength) {
        this.startPos = start;
        this.endPos = end;
        this.sentenceLength = sentenceLength;
    }

    public GeneralizedConstituent() {
    }

    public int getStart() {
        return this.startPos;
    }

    public int getEnd() {
        return this.endPos;
    }

    public int getSentenceLength() {
        return this.sentenceLength;
    }

    @Override
    public double getAverageLeftContextLength() {
        return (double)this.leftContexts / (double)this.matches;
    }

    @Override
    public double getAverageRightContextLength() {
        return (double)this.rightContexts / (double)this.matches;
    }

    @Override
    public double getSimilarFrequency() {
        return (double)this.matchingSequences / (double)this.overallSequences;
    }

    public double getScore() {
        return this.getSimilarFrequency();
    }

    public void setContextInfo(int overallSequences, int matchingSequences, int allMatches, int left, int right) {
        this.overallSequences = overallSequences;
        this.matchingSequences = matchingSequences;
        this.matches = allMatches;
        this.leftContexts = left;
        this.rightContexts = right;
    }

    public void addContextDetails(List<Reason> list) {
        this.matchDetails = list;
    }

    public List<Reason> getMatchDetails() {
        return this.matchDetails;
    }
}

