/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.data.impl;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IHypothesis;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class JustifiedHypothesis
implements IHypothesis {
    public int sequence;
    private byte left;
    private byte right;
    private List<Reason> reasons;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this.sequence);
        out.writeByte(this.left);
        out.writeByte(this.right);
        out.writeInt(this.reasons.size());
        for (Reason reason : this.reasons) {
            reason.writeObject(out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.sequence = in.readInt();
        this.left = in.readByte();
        this.right = in.readByte();
        int size = in.readInt();
        this.reasons = new ArrayList<Reason>(size);
        int i = 0;
        while (i < size) {
            Reason r = new Reason();
            r.readObject(in);
            this.reasons.add(r);
            ++i;
        }
    }

    public JustifiedHypothesis(int sequence, int left, int right) {
        this.sequence = sequence;
        this.left = (byte)(left - 127);
        this.right = (byte)(right - 127);
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    @Override
    public short getLeft() {
        return (short)(127 + this.left);
    }

    @Override
    public short getRight() {
        return (short)(127 + this.right);
    }

    public void setReasons(List<Reason> reasons) {
        this.reasons = reasons;
    }

    @Override
    public List<Reason> getReasons() {
        return this.reasons;
    }

    public int hashCode() {
        int prime = 1021;
        int result = 1;
        result = 1021 * result + this.left;
        result = 1021 * result + this.right;
        result = 1021 * result + this.sequence;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JustifiedHypothesis other = (JustifiedHypothesis)obj;
        if (this.left != other.left) {
            return false;
        }
        if (this.right != other.right) {
            return false;
        }
        return this.sequence == other.sequence;
    }

    public String toString() {
        return String.valueOf(this.sequence) + ": " + this.getLeft() + " - " + this.getRight();
    }

    public double getAverageRight() {
        if (this.reasons == null) {
            return 1.0;
        }
        double value = 0.0;
        for (Reason reason : this.reasons) {
            value += (double)reason.getLeftContextWidth();
        }
        return value / (double)this.reasons.size();
    }

    public double getAverageLeft() {
        if (this.reasons == null) {
            return 1.0;
        }
        double value = 0.0;
        for (Reason reason : this.reasons) {
            value += (double)reason.getRightContextWidth();
        }
        return value / (double)this.reasons.size();
    }
}

