/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.IWeightCalculator;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AllWOCalculator
implements IWeightCalculator {
    @Override
    public Map<Annotation<IGeneralizedHeuristicConstituent>, Double> getWeights(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
        HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = new HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double>(crossingHypotheses.size());
        for (Annotation<IGeneralizedHeuristicConstituent> annotation : crossingHypotheses) {
            weights.put(annotation, this.getWeight((IGeneralizedHeuristicConstituent)annotation.getDataObject()));
        }
        return weights;
    }

    private Double getWeight(IGeneralizedHeuristicConstituent dataObject) {
        GeneralizedConstituent gc = (GeneralizedConstituent)dataObject;
        List<Reason> reasons = gc.getMatchDetails();
        double best = 0.0;
        HashMap<Integer, Integer> count = new HashMap<Integer, Integer>();
        for (Reason reason : reasons) {
            int right;
            int left = reason.getLeftContextWidth() + reason.getLeftBonus();
            int width = left + (right = reason.getRightContextWidth() + reason.getRightBonus());
            Integer old = (Integer)count.get(width);
            if (old == null) {
                count.put(width, 1);
                continue;
            }
            count.put(width, old + 1);
        }
        for (Map.Entry entry : count.entrySet()) {
            best += Math.pow(2.0, ((Integer)entry.getKey()).intValue()) * Math.log(((Integer)entry.getValue()).intValue());
        }
        return best;
    }
}

