/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.IWeightCalculator;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BestWOCalculator
implements IWeightCalculator {
    @Override
    public Map<Annotation<IGeneralizedHeuristicConstituent>, Double> getWeights(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
        HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = new HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double>(crossingHypotheses.size());
        for (Annotation<IGeneralizedHeuristicConstituent> annotation : crossingHypotheses) {
            weights.put(annotation, this.getWeight((IGeneralizedHeuristicConstituent)annotation.getDataObject()));
        }
        return weights;
    }

    private Double getWeight(IGeneralizedHeuristicConstituent dataObject) {
        GeneralizedConstituent gc = (GeneralizedConstituent)dataObject;
        List<Reason> reasons = gc.getMatchDetails();
        int count = 0;
        double best = 0.0;
        for (Reason reason : reasons) {
            int right;
            int left = reason.getLeftContextWidth() + reason.getLeftBonus();
            if ((double)(left + (right = reason.getRightContextWidth() + reason.getRightBonus())) > best) {
                best = left + right;
                count = 1;
                continue;
            }
            if ((double)(left + right) != best) continue;
            ++count;
        }
        return Math.pow(2.0, best) * Math.log(count);
    }
}

