/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.ProgressSource;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.SimpleWeightCalculator;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.tunguska.access.TunguskaConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import edu.emory.mathcs.backport.java.util.Collections;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@Component(threadMode=ThreadMode.NOT_SUPPORTED, author={@Author(author="Stephan Schwiebert", email="sschwieb@spinfo.uni-koeln.de", web="http://www.spinfo.phil-fak.uni-koeln.de/sschwieb.html", organization="Sprachliche Informationsverarbeitung")}, description=@Description(name="Suffix Export", summary="Test select method", bigO="unknown", version="1.0", reusableResults=true))
public class ExportExchangables
extends TeslaComponent {
    private static final long serialVersionUID = 879812013823937578L;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Input")
    private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> hypotheses;
    @OutputAdapter(dataObject=GeneralizedConstituent.class, type=DefaultTunguskaOutputAdapter.ProtoStuff.class, name="Constituents", accessAdapterImpl=TunguskaConstituentAccessAdapter.DefaultTunguskaConstituentAccessAdapter.class, description="All constituents detected by the parser")
    @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector")
    private IOutputAdapter<GeneralizedConstituent> constituentOut;
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items", description="The items to align (for instance, words)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> words;
    private String weightCalculatorClass = SimpleWeightCalculator.class.getName();
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", description="The sequences to align (for instance, sentences)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;

    @Run
    public Result run() throws Exception {
        InputIterator signals = this.sequences.getAllSignalIds();
        signals.registerAsProgressBar((ProgressSource)this);
        HashMap<String, InContext> contexts = new HashMap<String, InContext>();
        while (signals.hasNext()) {
            String signalId = (String)signals.next();
            InputIterator seqs = this.sequences.getAnchoredElements(Range.forSignal((String)signalId), null, IAnchoredElement.class);
            while (seqs.hasNext()) {
                Annotation sequence = (Annotation)seqs.next();
                List items = this.words.getAnchoredElements(sequence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class).toList();
                InputIterator hypos = this.hypotheses.getAnnotations(sequence.getRange(false), null);
                while (hypos.hasNext()) {
                    Annotation hypothesis = (Annotation)hypos.next();
                    GeneralizedConstituent gc = (GeneralizedConstituent)hypothesis.getDataObject();
                    List<Reason> reasons = gc.getMatchDetails();
                    HashSet<String> analyzed = new HashSet<String>();
                    for (Reason reason : reasons) {
                        InContext ctx;
                        String s = String.valueOf(reason.getLeftContextWidth()) + "_" + reason.getRightContextWidth() + "_" + reason.getLeftBonus() + "_" + reason.getRightBonus();
                        if (!analyzed.add(s)) continue;
                        StringBuilder sb = new StringBuilder();
                        ArrayList<String> left = new ArrayList<String>();
                        ArrayList<String> right = new ArrayList<String>();
                        int i = gc.getStart() - 1;
                        while (i >= gc.getStart() - reason.getLeftContextWidth() && i >= 0) {
                            sb.append(String.valueOf(((Annotation)items.get(i)).getTypeId()) + "_");
                            left.add((String)((Annotation)items.get(i)).getSignalContent());
                            --i;
                        }
                        if (reason.getLeftBonus() > 0) {
                            sb.append("START");
                            left.add("START");
                        }
                        sb.append(" ");
                        i = gc.getEnd();
                        while (i <= gc.getEnd() + reason.getRightContextWidth() && i < items.size()) {
                            sb.append(String.valueOf(((Annotation)items.get(i)).getTypeId()) + "_");
                            right.add((String)((Annotation)items.get(i)).getSignalContent());
                            ++i;
                        }
                        if (reason.getRightBonus() > 0) {
                            sb.append("END");
                            right.add("END");
                        }
                        if ((ctx = (InContext)contexts.get(sb.toString())) == null) {
                            ctx = new InContext();
                            contexts.put(sb.toString(), ctx);
                            Collections.reverse(left);
                            ctx.leftCtx = ((Object)left).toString();
                            ctx.rightCtx = ((Object)right).toString();
                            ctx.leftLength = reason.getLeftContextWidth();
                            ctx.rightLength = reason.getRightContextWidth();
                            ctx.leftBonus = reason.getLeftBonus();
                            ctx.rightBonus = reason.getRightBonus();
                            ctx.baseLength = gc.getSentenceLength();
                        }
                        ArrayList<String> hypo = new ArrayList<String>();
                        int i2 = gc.getStart();
                        while (i2 < gc.getEnd()) {
                            hypo.add((String)((Annotation)items.get(i2)).getSignalContent());
                            ++i2;
                        }
                        ctx.replacements.add(((Object)hypo).toString());
                    }
                }
            }
        }
        ArrayList elements = new ArrayList(contexts.values());
        Collections.sort(elements);
        Iterator all = elements.iterator();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("output_classes.txt")));
        while (all.hasNext()) {
            InContext ctx = (InContext)all.next();
            if (ctx.replacements.size() == 1) continue;
            bw.write("****************************************\n");
            bw.write(String.valueOf(ctx.leftCtx) + "\t ... \t" + ctx.rightCtx + "\t" + (Math.pow(2.0, ctx.leftLength + ctx.leftBonus) + Math.pow(2.0, ctx.rightLength + ctx.rightBonus)) + "\n");
            Set<String> replacements = ctx.replacements;
            for (String string : replacements) {
                bw.write("\t" + string + "\n");
            }
            bw.write("\n");
        }
        bw.close();
        return this.cancelled() ? Result.CANCELLED : Result.OK;
    }

    class InContext
    implements Comparable<InContext> {
        String leftCtx;
        String rightCtx;
        int leftLength;
        int leftBonus;
        int rightLength;
        int rightBonus;
        Set<String> replacements = new HashSet<String>();
        double baseLength;

        InContext() {
        }

        double getScore() {
            return Math.pow(4.0, this.leftLength + this.leftBonus + this.rightLength + this.rightBonus) * (double)(this.leftLength + this.rightLength) / (this.baseLength - 1.0);
        }

        @Override
        public int compareTo(InContext o) {
            return Double.compare(this.getScore(), o.getScore());
        }
    }
}

