/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IAnnotationFactory;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.ExhaustiveSelectAlgorithm;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.GreedySelectAlgorithm;
import de.uni_koeln.spinfo.tesla.component.paradigms.select.IWeightCalculator;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class RandomizedSelectAlgorithm
extends ExhaustiveSelectAlgorithm {
    private Random random = new Random();
    private GreedySelectAlgorithm greedy = new GreedySelectAlgorithm();

    @Override
    public void setWeightCalculator(IWeightCalculator weightCalculator) {
        super.setWeightCalculator(weightCalculator);
        this.greedy.setWeightCalculator(weightCalculator);
    }

    @Override
    public void setAnnotationFactory(IAnnotationFactory annotationFactory) {
        super.setAnnotationFactory(annotationFactory);
        this.greedy.setAnnotationFactory(annotationFactory);
    }

    @Override
    public List<Annotation<IGeneralizedHeuristicConstituent>> resolveOverlaps(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
        if (crossingHypotheses.size() < 30) {
            return super.resolveOverlaps(crossingHypotheses);
        }
        Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = this.weightCalculator.getWeights(crossingHypotheses);
        List<Annotation<IGeneralizedHeuristicConstituent>> greedyResult = this.greedy.resolveOverlaps(crossingHypotheses);
        double best = 0.0;
        Map<Annotation<IGeneralizedHeuristicConstituent>, Double> tmp = this.weightCalculator.getWeights(greedyResult);
        for (Annotation<IGeneralizedHeuristicConstituent> annotation : greedyResult) {
            best += tmp.get(annotation).doubleValue();
        }
        Set<Annotation<IGeneralizedHeuristicConstituent>> currentBest = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
        currentBest.clear();
        currentBest.addAll(greedyResult);
        int i = 0;
        while (i < 2000) {
            Collections.shuffle(crossingHypotheses, this.random);
            Set<Annotation<IGeneralizedHeuristicConstituent>> set = this.guess(crossingHypotheses);
            double weight = this.getWeight(set, weights);
            if (weight >= best) {
                best = weight;
                currentBest = set;
            }
            ++i;
        }
        ArrayList<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new ArrayList<Annotation<IGeneralizedHeuristicConstituent>>();
        for (Annotation annotation : currentBest) {
            toReturn.add((Annotation<IGeneralizedHeuristicConstituent>)this.newConstituent((Annotation<IGeneralizedHeuristicConstituent>)annotation));
        }
        return toReturn;
    }

    protected double getWeight(Collection<Annotation<IGeneralizedHeuristicConstituent>> guessed, Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights) {
        double weight = 0.0;
        for (Annotation<IGeneralizedHeuristicConstituent> annotation : guessed) {
            weight += weights.get(annotation).doubleValue();
        }
        return weight;
    }

    private Set<Annotation<IGeneralizedHeuristicConstituent>> guess(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
        HashSet<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
        int i = 0;
        while (i < crossingHypotheses.size()) {
            Annotation<IGeneralizedHeuristicConstituent> chosen = crossingHypotheses.get(i);
            if (this.fits(chosen, toReturn)) {
                toReturn.add(chosen);
            }
            ++i;
        }
        return toReturn;
    }
}

