/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.test;

import com.dyuproject.protostuff.GraphIOUtil;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.HypothesisGenerator;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IMatch;
import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.AlignedSequence;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.NGramTree;
import de.uni_koeln.spinfo.tesla.component.paradigms.GlobalAlignmentDetector;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IHypothesis;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.JustifiedHypothesis;
import de.uni_koeln.spinfo.tesla.component.test.TestReasonList;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Test;

public class TestNaiveExhaustiveDetector {
    private Map<String, Integer> wordsToIds = new HashMap<String, Integer>();
    private Map<Integer, String> idsToWords = new HashMap<Integer, String>();
    private static LinkedBuffer buffer = LinkedBuffer.allocate((int)256);

    public int[] getMapping(List<String> words) {
        int[] mapping = new int[words.size()];
        int i = 0;
        while (i < words.size()) {
            String word = words.get(i);
            Integer id = this.wordsToIds.get(word);
            if (id == null) {
                id = this.wordsToIds.size();
                this.wordsToIds.put(word, id);
                this.idsToWords.put(id, word);
            }
            mapping[i] = id;
            ++i;
        }
        return mapping;
    }

    public List<String> getWordList(String sentence) {
        String[] splitted;
        ArrayList<String> words = new ArrayList<String>();
        String[] stringArray = splitted = sentence.split(" ");
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String word = stringArray[n2];
            words.add(word);
            ++n2;
        }
        return words;
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void main() {
        void var14_19;
        ArrayList<List<String>> sentences = new ArrayList<List<String>>();
        sentences.add(this.getWordList("Ich esse Fisch"));
        sentences.add(this.getWordList("Ich esse Fleisch"));
        sentences.add(this.getWordList("Peter liebt Maria"));
        sentences.add(this.getWordList("Hans liebt Maria"));
        sentences.add(this.getWordList("Er kauft Fisch"));
        sentences.add(this.getWordList("Er hasst Fisch"));
        sentences.add(this.getWordList("Anton mag Petra"));
        sentences.add(this.getWordList("Anton mag Petra sehr"));
        sentences.add(this.getWordList("Herr Meier tanzt besessen vor sich hin"));
        sentences.add(this.getWordList("Karl tanzt besessen vor sich hin"));
        sentences.add(this.getWordList("Die alte Frau trinkt eklige warme Cola"));
        sentences.add(this.getWordList("Die alte Frau trinkt kalte Cola"));
        sentences.add(this.getWordList("Ich esse sehr gerne Fisch"));
        sentences.add(this.getWordList("Michael Jackson lebt"));
        sentences.add(this.getWordList("Jackson lebt"));
        sentences.add(this.getWordList("Das stimmt"));
        sentences.add(this.getWordList("Das stimmt nicht"));
        sentences.add(this.getWordList("Petra liebt Anton"));
        sentences.add(this.getWordList("Ein Vogel fliegt"));
        sentences.add(this.getWordList("Ein Frosch schwimmt"));
        sentences.add(this.getWordList("Otto gibt auf"));
        sentences.add(this.getWordList("Anna steht auf"));
        ArrayList<int[]> sequences = new ArrayList<int[]>();
        HashSet<List<String>> expected = new HashSet<List<String>>();
        expected.add(this.getWordList("Ich esse"));
        expected.add(this.getWordList("Fisch"));
        expected.add(this.getWordList("Fleisch"));
        expected.add(this.getWordList("Peter"));
        expected.add(this.getWordList("Hans"));
        expected.add(this.getWordList("kauft"));
        expected.add(this.getWordList("kauft Fisch"));
        expected.add(this.getWordList("Er kauft"));
        expected.add(this.getWordList("Er hasst"));
        expected.add(this.getWordList("hasst"));
        expected.add(this.getWordList("hasst Fisch"));
        expected.add(this.getWordList("sehr"));
        expected.add(this.getWordList("Herr Meier"));
        expected.add(this.getWordList("Karl"));
        expected.add(this.getWordList("eklige warme"));
        expected.add(this.getWordList("kalte"));
        expected.add(this.getWordList("eklige warme Cola"));
        expected.add(this.getWordList("kalte Cola"));
        expected.add(this.getWordList("Die alte Frau trinkt kalte"));
        expected.add(this.getWordList("Die alte Frau trinkt eklige warme"));
        expected.add(this.getWordList("Ich esse sehr gerne"));
        expected.add(this.getWordList("sehr gerne"));
        expected.add(this.getWordList("gerne Fisch"));
        expected.add(this.getWordList("sehr gerne Fisch"));
        expected.add(this.getWordList("Anton mag Petra"));
        expected.add(this.getWordList("Michael"));
        expected.add(this.getWordList("nicht"));
        expected.add(this.getWordList("Petra"));
        expected.add(this.getWordList("Anton"));
        expected.add(this.getWordList("Petra liebt"));
        expected.add(this.getWordList("Maria"));
        expected.add(this.getWordList("mag Petra sehr"));
        expected.add(this.getWordList("Anton mag"));
        expected.add(this.getWordList("mag Petra"));
        expected.add(this.getWordList("liebt Anton"));
        expected.add(this.getWordList("Vogel fliegt"));
        expected.add(this.getWordList("Frosch schwimmt"));
        expected.add(this.getWordList("Otto gibt"));
        expected.add(this.getWordList("Anna steht"));
        for (List list : sentences) {
            int[] mapping = this.getMapping(list);
            sequences.add(mapping);
        }
        HashSet<List<String>> hashSet = new HashSet<List<String>>();
        hashSet.add(this.getWordList("Ich esse"));
        hashSet.add(this.getWordList("Maria"));
        hashSet.add(this.getWordList("Anton mag"));
        NGramTree suffixes = new NGramTree(200);
        int counter = 0;
        for (int[] sentence : sequences) {
            suffixes.insert(sentence, counter, false);
            ++counter;
        }
        suffixes.trim();
        NGramTree prefixes = new NGramTree(200);
        counter = 0;
        for (int[] sentence : sequences) {
            prefixes.insert(sentence, counter, true);
            ++counter;
        }
        prefixes.reversePositions(sequences);
        final ArrayList sList = new ArrayList();
        HypothesisGenerator align = new HypothesisGenerator(){

            @Override
            protected void storeResults(List<Future<AlignedSequence>> results, ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix, ArrayList<Annotation<IAnchoredElement>> baseAnnotations) throws InterruptedException, ExecutionException {
                Iterator<Future<AlignedSequence>> iterator = results.iterator();
                while (iterator.hasNext()) {
                    AlignedSequence alignedSequence = iterator.next().get();
                    sList.add(alignedSequence);
                }
            }
        };
        Map<Integer, List<INode>> suffixNodes = align.getTypeMapping(1, 1, suffixes);
        Map<Integer, List<INode>> prefixNodes = align.getTypeMapping(1, 1, prefixes);
        align.setSequences(sequences);
        try {
            align.process(suffixNodes, prefixNodes);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        ArrayList<JustifiedHypothesis> all = new ArrayList<JustifiedHypothesis>();
        GlobalAlignmentDetector detector = new GlobalAlignmentDetector(true, true, sequences, null);
        boolean bl = false;
        while (var14_19 < sList.size()) {
            AlignedSequence sequence = (AlignedSequence)sList.get((int)var14_19);
            Collection<JustifiedHypothesis> hypotheses = detector.analyzeSequence(sequence, 0, 0);
            all.addAll(hypotheses);
            if (var14_19 % 1000 == false) {
                System.out.println("Processed " + (int)var14_19 + " sequences.");
            }
            ++var14_19;
        }
        for (IHypothesis iHypothesis : all) {
            int[] list = sequences.get(iHypothesis.getSequence());
            List<String> original = this.convertBack(list);
            System.out.println("Sentence " + iHypothesis.getSequence() + ": " + original);
            List<String> consti = original.subList(iHypothesis.getLeft(), iHypothesis.getRight());
            System.out.println("       Constituent: " + consti);
            TestReasonList reasons = (TestReasonList)iHypothesis.getReasons();
            for (IMatch match : reasons.getMatches()) {
                List<String> other = this.convertBack(sequences.get(match.sequence()));
                System.out.println("LC: " + match.start().wordPos() + " in " + other);
                System.out.println("RC: " + match.end().wordPos() + " in " + other);
            }
            boolean removed = expected.remove(consti);
            if (!removed) {
                removed = hashSet.remove(consti);
            }
            if (removed) {
                System.out.println("SUCCESS!!!");
            }
            if (!removed) {
                System.out.println("FAILURE: Didn't find or expect " + consti + "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
            }
            System.out.println();
            System.out.println();
        }
        if (!expected.isEmpty()) {
            System.out.println("Missed first time: " + expected);
        }
        Assert.assertTrue((boolean)expected.isEmpty());
        if (!hashSet.isEmpty()) {
            System.out.println("Missed second time: " + hashSet);
        }
        Assert.assertTrue((boolean)hashSet.isEmpty());
        try {
            this.testStoreAndLoad(all);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void testStoreAndLoad(List<JustifiedHypothesis> all) throws IOException {
        File file = File.createTempFile("test", "test");
        file.deleteOnExit();
        TestContainer test = new TestContainer();
        test.list = new ArrayList<JustifiedHypothesis>(all);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(file));
        ArrayList<JustifiedHypothesis> backup = new ArrayList<JustifiedHypothesis>(all);
        RuntimeSchema schema = RuntimeSchema.createFrom(test.getClass());
        byte[] bytes = TestNaiveExhaustiveDetector.toBytes(test, (Schema)schema);
        System.out.println("Writing: " + bytes.length);
        out.writeInt(bytes.length);
        out.write(bytes, 0, bytes.length);
        out.close();
        DataInputStream in = new DataInputStream(new FileInputStream(file));
        TestContainer test2 = new TestContainer();
        int size = in.readInt();
        byte[] data = new byte[size];
        in.readFully(data);
        TestNaiveExhaustiveDetector.fromBytes(data, schema, test2, size);
        List listA = test.list;
        List listB = test2.list;
        int i = 0;
        while (i < listA.size()) {
            if (((JustifiedHypothesis)listA.get(i)).getLeft() != ((JustifiedHypothesis)listB.get(i)).getLeft()) {
                System.out.println("Falsch!");
            }
            ++i;
        }
    }

    protected static byte[] toBytes(Object dataObject, Schema schema) {
        byte[] array = GraphIOUtil.toByteArray((Object)dataObject, (Schema)schema, (LinkedBuffer)buffer);
        buffer.clear();
        return array;
    }

    protected static <T> void fromBytes(byte[] data, Schema<T> schema, T object, int length) {
        GraphIOUtil.mergeFrom((byte[])data, (int)0, (int)length, object, schema);
    }

    private List<String> convertBack(int[] list) {
        ArrayList<String> original = new ArrayList<String>(list.length);
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            Integer value = nArray[n2];
            original.add(this.idsToWords.get(value));
            ++n2;
        }
        return original;
    }

    class TestContainer {
        private List<JustifiedHypothesis> list;

        TestContainer() {
        }
    }
}

