/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.util;

import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MatrixLoader {
    private ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix;
    ArrayList<Long> sequenceIds;
    ArrayList<Annotation<IAnchoredElement>> sequencesList;
    private Map<Long, Integer> typeMap = new HashMap<Long, Integer>();

    public ArrayList<int[]> loadData(List<String> signalIds, TeslaComponent component, IAnchoredElementAccessAdapter<IAnchoredElement> sequences, IAnchoredElementAccessAdapter<IAnchoredElement> words, double overall) {
        ArrayList<int[]> sequenceMatrix = new ArrayList<int[]>();
        this.dataMatrix = new ArrayList();
        this.sequenceIds = new ArrayList(signalIds.size());
        this.sequencesList = new ArrayList();
        int empty = 0;
        double step = overall / (double)signalIds.size();
        double current = 0.0;
        for (String sid : signalIds) {
            InputIterator sequenceIterator = sequences.getAnchoredElements(Range.forSignal((String)sid), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
            while (sequenceIterator.hasNext()) {
                Annotation sequence = (Annotation)sequenceIterator.next();
                this.sequenceIds.add(sequence.getId());
                this.sequencesList.add((Annotation<IAnchoredElement>)sequence);
                InputIterator wordIterator = words.getAnchoredElements(sequence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
                ArrayList<Annotation> wordList = new ArrayList<Annotation>();
                while (wordIterator.hasNext()) {
                    wordList.add((Annotation)wordIterator.next());
                }
                wordList.trimToSize();
                this.dataMatrix.add(wordList);
                int[] array = new int[wordList.size()];
                int i = 0;
                while (i < wordList.size()) {
                    long typeId = ((Annotation)wordList.get(i)).getTypeId();
                    Integer type = this.typeMap.get(typeId);
                    if (type == null) {
                        type = this.typeMap.size();
                        this.typeMap.put(typeId, type);
                    }
                    array[i] = type;
                    ++i;
                }
                sequenceMatrix.add(array);
                if (array.length != 0) continue;
                ++empty;
            }
            component.setProgress((int)(current += step));
        }
        if (empty > 0) {
            Logger.getLogger(this.getClass()).warn((Object)("Inserted " + empty + " sequences of length 0"));
        }
        sequenceMatrix.trimToSize();
        this.sequenceIds.trimToSize();
        return sequenceMatrix;
    }

    public ArrayList<List<Annotation<IAnchoredElement>>> getDataMatrix() {
        return this.dataMatrix;
    }

    public ArrayList<Long> getSequenceIds() {
        return this.sequenceIds;
    }

    public ArrayList<Annotation<IAnchoredElement>> getSequencesList() {
        return this.sequencesList;
    }

    public void setSequencesList(ArrayList<Annotation<IAnchoredElement>> sequencesList) {
        this.sequencesList = sequencesList;
    }

    public void release() {
        this.dataMatrix = null;
        this.sequenceIds = null;
        this.sequencesList = null;
    }
}

