/*
 * Decompiled with CFR 0.152.
 */
package de.uni_koeln.spinfo.tesla.component.patterndetector;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INgramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.patterndetector.INodeChain;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;

public class PatternDetector {
    private INgramTree tree;

    public PatternDetector(INgramTree tree) {
        this.tree = tree;
    }

    public Set<INodeChain> getAllPatterns(int minFreq, int minLength) {
        Set<INodeChain> toReturn = new HashSet<INodeChain>();
        INode root = this.tree.getRoot();
        toReturn = this.getAllPatterns(root, minFreq, toReturn, true);
        HashSet<INodeChain> toRemove = new HashSet<INodeChain>();
        for (INodeChain iNodeChain : toReturn) {
            if (iNodeChain.isEmpty()) {
                toRemove.add(iNodeChain);
                continue;
            }
            if (iNodeChain.getDeepestNode().getDepth() >= minLength) continue;
            toRemove.add(iNodeChain);
        }
        for (INodeChain iNodeChain : toRemove) {
            toReturn.remove(iNodeChain);
        }
        return toReturn;
    }

    private Set<INodeChain> getAllPatterns(INode node, int minFreq, Set<INodeChain> longestChains, boolean isRoot) {
        if (!(isRoot || node.getReferencedPositions().size() >= minFreq && node.getChildren() != null)) {
            longestChains.add(new INodeChain());
            return longestChains;
        }
        Set children = node.getChildren();
        for (INode child : children) {
            longestChains.addAll(this.getAllPatterns(child, minFreq, new HashSet<INodeChain>(), false));
        }
        if (!isRoot) {
            for (INodeChain iNodeChain : longestChains) {
                iNodeChain.addFrontNode(node);
            }
        }
        return longestChains;
    }

    public Set<INodeChain> getLongestPatterns(int minFreq) {
        Set<INodeChain> toReturn = new HashSet<INodeChain>();
        INode root = this.tree.getRoot();
        toReturn = this.getLongestPatterns(root, minFreq, toReturn, true);
        return toReturn;
    }

    private Set<INodeChain> getLongestPatterns(INode node, int minFreq, Set<INodeChain> longestChains, boolean isRoot) {
        if (!(isRoot || node.getReferencedPositions().size() >= minFreq && node.getChildren() != null)) {
            longestChains.add(new INodeChain());
            return longestChains;
        }
        Set children = node.getChildren();
        TreeMap<Integer, HashSet<INodeChain>> childrenChains = new TreeMap<Integer, HashSet<INodeChain>>();
        for (INode child : children) {
            Set<INodeChain> longestPatterns = this.getLongestPatterns(child, minFreq, new HashSet<INodeChain>(), false);
            int key = longestPatterns.iterator().next().size();
            HashSet<INodeChain> inMap = (HashSet<INodeChain>)childrenChains.get(key);
            if (inMap == null) {
                inMap = new HashSet<INodeChain>();
            }
            inMap.addAll(longestPatterns);
            childrenChains.put(key, inMap);
        }
        Set toReturn = (Set)childrenChains.get(childrenChains.lastKey());
        if (!isRoot) {
            for (INodeChain iNodeChain : toReturn) {
                iNodeChain.addFrontNode(node);
            }
        }
        return toReturn;
    }
}

