package de.uni_koeln.spinfo.tesla.component.patterndetector;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;


import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INgramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;


public class PatternDetector {
	
	private INgramTree tree;

	
	public PatternDetector(INgramTree tree){
		this.tree = tree;
	}
		
//	public Set<INodeChain> getMostFrequentPatterns(int minLength){
//		Set<INodeChain> toReturn = new HashSet<INodeChain>();
//		INode root = tree.getRoot();
//		toReturn = getMostFrequentPatterns(root, minLength, toReturn, 0, true);
//		return toReturn;		
//	}
//	
//	private Set<INodeChain> getMostFrequentPatterns(INode node, int minLength, Set<INodeChain> mostFrequnentChains, int frequencyOfAncessor, boolean isRoot) {
//		SortedMap<Integer, INodeChain> childrenChains = new TreeMap<Integer,INodeChain>();
//		Set<INode> children = node.getChildren();
//		for (INode iNode : children) {
//			Set<INodeChain> mostFrequentPatterns = getMostFrequentPatterns(iNode, minLength, mostFrequnentChains, node.getReferencedPositions().size(), false);
//			//childrenChains.put(, mostFrequentPatterns);
//		}
//		//if length < minLength search deeper node
//		if(frequencyOfAncessor==0){
//			
//		}
//		
//		//If frequency is decreasing, return
//		if(node.getReferencedPositions().size()<frequencyOfAncessor){
//			return mostFrequnentChains;
//		}
//		
//		
//		
//		else{
//			
//		}
//		
//		
//		//Check if current chain is long enough
//		if(node.getDepth()<minLength){
//			frequencyOfAncessor = 0;
//		}
//		else{
//			frequencyOfAncessor = node.getReferencedPositions().size();
//		}
//		
//		
//		Set<INode> children = node.getChildren();
//		for (INode iNode : children) {
//			
//		}
//		
//		return mostFrequnentChains;
//	}
	
	public Set<INodeChain> getAllPatterns(int minFreq, int minLength){
		Set<INodeChain> toReturn = new HashSet<INodeChain>();
		INode root = tree.getRoot();
		toReturn = getAllPatterns(root, minFreq, toReturn, true);
		Set<INodeChain> toRemove = new HashSet<INodeChain>();
		for (INodeChain iNodeChain : toReturn) {
			if(iNodeChain.isEmpty()){
				toRemove.add(iNodeChain);
				continue;
			}
			else{
				if(iNodeChain.getDeepestNode().getDepth()<minLength){
					toRemove.add(iNodeChain);
				}
			}
		}
		for (INodeChain iNodeChain : toRemove) {
			toReturn.remove(iNodeChain);
		}
		return toReturn;
	}
	
	private Set<INodeChain> getAllPatterns(INode node, int minFreq, Set<INodeChain> longestChains, boolean isRoot) {
		//If node frequency lower than required, add new chain to result list and return it 
		if(!isRoot && (node.getReferencedPositions().size()<minFreq || node.getChildren()==null)){
			longestChains.add(new INodeChain());
			return longestChains;
		}
		//Get node children
		Set<INode> children = node.getChildren();
		//SortedMap<Integer, Set<INodeChain>> childrenChains = new TreeMap<Integer, Set<INodeChain>>();
		//Get longest chain of each child, aggregate them (by length) on sorted map
		
		//Get longest children chains
		//Set<INodeChain> toReturn = childrenChains.get(childrenChains.lastKey());
		
		for (INode child : children) {
			longestChains.addAll(getAllPatterns(child, minFreq, new HashSet<INodeChain>(), false));
		}
		
		//Add this node on first position
		if(!isRoot){
			for (INodeChain iNodeChain : longestChains) {
				iNodeChain.addFrontNode(node); 
			}
		}	
		//Return longest chains
		return longestChains;
	}

	public Set<INodeChain> getLongestPatterns(int minFreq){
		Set<INodeChain> toReturn = new HashSet<INodeChain>();
		INode root = tree.getRoot();
		toReturn = getLongestPatterns(root, minFreq, toReturn, true);
		return toReturn;
	}

	private Set<INodeChain> getLongestPatterns(INode node, int minFreq, Set<INodeChain> longestChains, boolean isRoot) {
		//If node frequency lower than required, add new chain to result list and return it 
		if(!isRoot && (node.getReferencedPositions().size()<minFreq || node.getChildren()==null)){
			longestChains.add(new INodeChain());
			return longestChains;
		}
		//Get node children
		Set<INode> children = node.getChildren();
		SortedMap<Integer, Set<INodeChain>> childrenChains = new TreeMap<Integer, Set<INodeChain>>();
		//Get longest chain of each child, aggregate them (by length) on sorted map
		for (INode child : children) {
			Set<INodeChain> longestPatterns = getLongestPatterns(child, minFreq, new HashSet<INodeChain>(), false);
			int key = longestPatterns.iterator().next().size();
			Set<INodeChain> inMap = childrenChains.get(key);
			if(inMap==null){
				inMap = new HashSet<INodeChain>();
			}
			inMap.addAll(longestPatterns);
			childrenChains.put(key, inMap);
		}
		//Get longest children chains
		Set<INodeChain> toReturn = childrenChains.get(childrenChains.lastKey());
		
		//Add this node on first position
		if(!isRoot){
			for (INodeChain iNodeChain : toReturn) {
				iNodeChain.addFrontNode(node); 
			}
		}
		
		//Return longest chains
		return toReturn;
	}
	
//	public Set<INode> getLongestPatternNodes(int minFreq){
//		Set<INode> toReturn = new HashSet<INode>();
//		INode root = tree.getRoot();				
//		toReturn = getLongestPatternNodes(root, toReturn, minFreq, true);
//		return toReturn;
//	}
//	
//	public Set<INode> getLongestPatternNodes(INode node, Set<INode> longestPatternNodes, int minFreq, boolean isRoot){
//		//If frequency of this node is to low, return	
//		if(!isRoot && node.getReferencedPositions().size()<minFreq){
//			return longestPatternNodes;
//		}
//		//If node has no children, add node to node Set, return
//		Set<INode> children = node.getChildren();
//		if(children==null){
//			longestPatternNodes.add(node);
//			return longestPatternNodes;
//		}
//		
//		//Aggregate childrens longest patterns in Map
//		SortedMap<Integer, Set<INode>> childrenPatterns = new TreeMap<Integer, Set<INode>>();
//		for (INode child : children) {
//			Set<INode> childsLongestPatterns = getLongestPatternNodes(child, longestPatternNodes, minFreq, false);
//			if(!childsLongestPatterns.isEmpty()){
//				INode first = childsLongestPatterns.iterator().next();
//				childrenPatterns.put(first.getDepth(), childsLongestPatterns);
//			}
//		}
//		
//		//Choose deepest nodes to return
//		if(childrenPatterns.isEmpty()){
//			longestPatternNodes.add(node);
//			return longestPatternNodes;
//		}
//		longestPatternNodes.addAll(childrenPatterns.get(childrenPatterns.lastKey()));		
//		return longestPatternNodes;
//	}
}
