package de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl;

import gnu.trove.iterator.TIntIterator;
import gnu.trove.map.hash.TIntIntHashMap;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Iterator;

public class ContextPositionList implements Iterable<ContextPosition>, Serializable, Externalizable {
	
	private static final long serialVersionUID = -18802263553031454L;
	private TIntIntHashMap list = new TIntIntHashMap(64);

	private static final int seqmask = 1048575 << 12;
	private static final int wpmask = 255 << 4;
	private static final int cpmask = 15;
	
	private ContextPosition decode(int value) {
		int seq = (value & seqmask) >> 12;
		int wp = (value & wpmask) >> 4;
		int cp = value & cpmask;
		return new ContextPosition(seq, wp, cp);
	}
	

	@Override
	public void writeExternal(ObjectOutput out) throws IOException {
		out.writeInt(list.size());
		list.writeExternal(out);
	}

	@Override
	public void readExternal(ObjectInput in) throws IOException,
			ClassNotFoundException {
		int size = in.readInt();
		list = new TIntIntHashMap(size);
		list.readExternal(in);
	}

	
	/**
	 * Inserts a new contextposition only if it has not already been inserted,
	 * or if it has been inserted with a smaller depth.
	 * @param seqId
	 * @param wp
	 * @param depth
	 */
	public void insertOrUpdate(int seqId, int wp, int depth) {
		if(depth > 15) depth = 15;
		int searchKey = seqId << 12 | wp;
		int fullKey = seqId << 12 |wp << 4 | depth;
		int old = list.put(searchKey, fullKey);
		if(old > fullKey && old != list.getNoEntryValue()) {
			list.put(searchKey, old);
		}
		
	}
	
	public int size() {
		return list.size();
	}

	public Iterator<ContextPosition> iterator() {
		return new Iterator<ContextPosition>() {

			TIntIterator iterator = list.valueCollection().iterator();
			
			@Override
			public boolean hasNext() {
					return iterator.hasNext();
			}

			@Override
			public ContextPosition next() {
				return decode(iterator.next());
			}

			@Override
			public void remove() {
				
			}
		};
	}

	public void trim() {
		list.trimToSize();
	}

	@Override
	public int hashCode() {
		return list.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if(obj == null) return false;
		return ((ContextPositionList)obj).list.equals(list);
	}

	
	
}