package de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl;

import java.io.Serializable;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;

/**
 * Represents an element position within a sequence.
 * Note that the word Position is stored as a byte - sequence containing more than 255
 * words are not supported.
 * 
 * @author sschwieb
 *
 */
public class PosPair implements IPosition, Comparable<PosPair>, Serializable {
	
	private static final long serialVersionUID = -433860276632788540L;

	/**
	 * Factory method to create a new PosPair.
	 * @param sequenceId
	 * @param wordPos
	 * @return
	 */
	public static PosPair newPair(int sequenceId, short wordPos) {
		return new PosPair(sequenceId, wordPos);
	}
	
	private static final int posMask = 255;

	public PosPair(int sequence, int wordPos) {
		this.sequence = (sequence << 8) | (wordPos & posMask);
	}
	
	private final int sequence;
	
	@Override
	public String toString() {
		return getSequenceIndex() + "/" + getElementIndex();	
	}
	
	@Override
	public int hashCode() {
		return sequence;
	}
	
	/* (non-Javadoc)
	 * @see org.schwiebert.suffixtree.trees.IPosition#wordPos()
	 */
	@Override
	public short getElementIndex() {
		return (short) (sequence & posMask);
	}
	
	@Override
	public boolean equals(Object obj) {
		return ((PosPair)obj).sequence == sequence;
	}
	
	@Override
	public int compareTo(PosPair o) {
		return sequence - o.sequence;
	}
	

	public int getSequenceIndex() {
		return sequence >> 8;
	}

}
