package de.uni_koeln.spinfo.tesla.component.paradigms.data.impl;

import java.util.ArrayList;
import java.util.List;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.hibernate.data.MultiLabelConstituent;


public class GeneralizedConstituent extends MultiLabelConstituent implements IGeneralizedHeuristicConstituent {

	private static final long serialVersionUID = -248098513899278750L;
	private int startPos;
	private int endPos;
	private int sentenceLength;
	private int rightContexts;
	private int leftContexts;
	private int matches;
	private int matchingSequences;
	private int overallSequences;
	private List<Reason> matchDetails = new ArrayList<Reason>();
	
	public GeneralizedConstituent(int start, int end, int maxLeft, int maxRight, int sentenceLength) {
		this.startPos = start;
		this.endPos = end;
		this.sentenceLength = sentenceLength;
	}
	
	public GeneralizedConstituent() {}
	
	/**
	 * Returns the index of the first word which belongs to this hypothesis. 
	 * @return
	 */
	public int getStart() {
		return startPos;
	}

	/**
	 * Returns the index of the first word which does not belong to this hypothesis.
	 * @return
	 */
	public int getEnd() {
		return endPos;
	}


	public int getSentenceLength() {
		return sentenceLength;
	}

	public double getAverageLeftContextLength() {
		return leftContexts/(double)matches;
	}
	
	public double getAverageRightContextLength() {
		return rightContexts/(double)matches;
	}
	
	public double getSimilarFrequency() {
		return matchingSequences/(double)overallSequences;
	}
	
	@Override
	public double getScore() {
		return getSimilarFrequency();
	}

	public void setContextInfo(int overallSequences, int matchingSequences, int allMatches, int left, int right) {
		this.overallSequences = overallSequences;
		this.matchingSequences = matchingSequences;
		this.matches = allMatches;
		this.leftContexts = left;
		this.rightContexts = right;
	}

	public void addContextDetails(List<Reason> list) {
		this.matchDetails = list;
	}

	public List<Reason> getMatchDetails() {
		return matchDetails;
	}


	
	

}
