package de.uni_koeln.spinfo.tesla.component.paradigms.data.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IHypothesis;



public class JustifiedHypothesis implements IHypothesis {

	public int sequence;
	
	private byte left, right;

	private List<Reason> reasons;
	
	private void writeObject(ObjectOutputStream out) throws IOException {
		out.writeInt(sequence);
		out.writeByte(left);
		out.writeByte(right);
		out.writeInt(reasons.size());
		for (Reason reason : reasons) {
			reason.writeObject(out);
		}
	}
	
	 private void readObject(ObjectInputStream in)  throws IOException, ClassNotFoundException {
		 sequence = in.readInt();
		 left = in.readByte();
		 right = in.readByte();
		 final int size = in.readInt();
		 reasons = new ArrayList<Reason>(size);
		 for(int i = 0; i < size; i++) {
			 Reason r = new Reason();
			 r.readObject(in);
			 reasons.add(r);
		 }
	 }
	
	/**
	 * @param sequence
	 * @param left
	 * @param right
	 */
	public JustifiedHypothesis(int sequence, int left, int right) {
		this.sequence = sequence;
		this.left = (byte) (left-127);
		this.right = (byte) (right-127);
	}

	@Override
	public int getSequence() {
		return sequence;
	}

	@Override
	public short getLeft() {
		return (short) (127 + left);
	}

	@Override
	public short getRight() {
		return (short) (127 + right);
	}

	public void setReasons(List<Reason> reasons) {
		this.reasons = reasons;
	}

	public List<Reason> getReasons() {
		return reasons;
	}

	@Override
	public int hashCode() {
		final int prime = 1021;
		int result = 1;
		result = prime * result + left;
		result = prime * result + right;
		result = prime * result + sequence;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		JustifiedHypothesis other = (JustifiedHypothesis) obj;
		if (left != other.left)
			return false;
		if (right != other.right)
			return false;
		if (sequence != other.sequence)
			return false;
		return true;
	}

	@Override
	public String toString() {
		return(sequence + ": " + getLeft() + " - " + getRight());
	}
	
	public double getAverageRight() {
		if(reasons == null) return 1;
		double value = 0;
		for (Reason reason : reasons) {
			value += reason.getLeftContextWidth();
		}
		return value / reasons.size();
	}

	public double getAverageLeft() {
		if(reasons == null) return 1;
		double value = 0;
		for (Reason reason : reasons) {
			value += reason.getRightContextWidth();
		}
		return value / reasons.size();
	}

	
	
}
