package de.uni_koeln.spinfo.tesla.component.paradigms.data.impl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class Reason implements Serializable {
	
	private static final long serialVersionUID = 8313419901832367120L;

	// Aktuell:
	// 6 * 2 Byte + 4 Byte + 8 Byte = 24
	// Bringt nix:
	// 6 * 1 Byte + 4 Byte + 8 Byte = 18 -> 24 Byte
	// Nur sinnvoll, wenn max 16 Byte - dafür müsste sequence kürzer gemacht werden,
	// und bspw. left & right Bonus hinzugefügt, wie bei ContextPosition.
	// left & right cw & b jeweils 4 bit -> insg. 2 byte
	// 2 + 4 + 8 = 14 byte -> 16 Byte
	
	private byte from, to;
	
	private byte leftContextWidth, rightContextWidth;

	private byte leftBonus, rightBonus;
	
	private int sequence;
	
	public void writeObject(ObjectOutputStream out) throws IOException {
		out.writeInt(sequence);
		out.writeShort(from);
		out.writeShort(to);
		out.writeByte(leftContextWidth);
		out.writeByte(rightContextWidth);
		out.writeByte(leftBonus);
		out.writeByte(rightBonus);
	}
	 public void readObject(ObjectInputStream in)  throws IOException, ClassNotFoundException {
		 sequence = in.readInt();
		 from = in.readByte();
		 to = in.readByte();
		 leftContextWidth = in.readByte();
		 rightContextWidth = in.readByte();
		 leftBonus = in.readByte();
		 rightBonus = in.readByte();
	 }
	
	public short getLeftBonus() {
		return leftBonus;
	}

	public void setLeftBonus(int startBonus) {
		this.leftBonus = convert(startBonus);
	}

	public short getRightBonus() {
		return rightBonus;
	}

	public void setRightBonus(int rightBonus) {
		this.rightBonus = convert(rightBonus);
	}

	/**
	 * Returns the position of the first character which
	 * is part of the reason.
	 * @return
	 */
	public int getFrom() {
		return from;
	}

	public void setFrom(int from) {
		this.from = convert(from);
	}

	private byte convert(int value) {
		return (byte) value;
	}
	public int getTo() {
		return to;
	}

	/**
	 * Returns the position of the first character which
	 * is not part of the reason.
	 * @param to
	 */
	public void setTo(int to) {
		this.to = convert(to);
	}

	public int getLeftContextWidth() {
		return leftContextWidth;
	}

	public void setLeftContextWidth(int leftContextWidth) {
		this.leftContextWidth = convert(leftContextWidth);
	}

	public int getRightContextWidth() {
		return rightContextWidth;
	}

	public void setRightContextWidth(int rightContextWidth) {
		this.rightContextWidth = convert(rightContextWidth);
	}

	public void setSequence(int sequence) {
		this.sequence = sequence;
	}

	public int getSequence() {
		return sequence;
	}
	
	public boolean isEmpty() {
		return from == to;
	}
	

}
