package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class AllWOCalculator implements IWeightCalculator {


	public Map<Annotation<IGeneralizedHeuristicConstituent>, Double> getWeights(
			List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		final Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = new HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double>(crossingHypotheses.size());
		for (Annotation<IGeneralizedHeuristicConstituent> annotation : crossingHypotheses) {
			weights.put(annotation, getWeight(annotation.getDataObject()));
		}
		return weights;
	}

	private Double getWeight(IGeneralizedHeuristicConstituent dataObject) {
		GeneralizedConstituent gc = (GeneralizedConstituent) dataObject;
		List<Reason> reasons = gc.getMatchDetails();
		double best = 0;
		Map<Integer, Integer> count = new HashMap<Integer, Integer>();
		for (Reason reason : reasons) {
			int left = reason.getLeftContextWidth() + reason.getLeftBonus();
			int right = reason.getRightContextWidth() + reason.getRightBonus();
			int width = left + right;
			Integer old = count.get(width);
			if(old == null) {
				count.put(width, 1);
			} else {
				count.put(width, old+1);
			}
		}
		Iterator<Entry<Integer, Integer>> entries = count.entrySet().iterator();
		while(entries.hasNext()) {
			Entry<Integer, Integer> entry = entries.next();
			best += Math.pow(2, entry.getKey()) * Math.log(entry.getValue());
		}
		return best;
	}

}
