package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class BestWOCalculator implements IWeightCalculator {


	public Map<Annotation<IGeneralizedHeuristicConstituent>, Double> getWeights(
			List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		final Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = new HashMap<Annotation<IGeneralizedHeuristicConstituent>, Double>(crossingHypotheses.size());
		for (Annotation<IGeneralizedHeuristicConstituent> annotation : crossingHypotheses) {
			weights.put(annotation, getWeight(annotation.getDataObject()));
		}
		return weights;
	}

	private Double getWeight(IGeneralizedHeuristicConstituent dataObject) {
		GeneralizedConstituent gc = (GeneralizedConstituent) dataObject;
		List<Reason> reasons = gc.getMatchDetails();
		int count = 0;
		double best = 0;
		for (Reason reason : reasons) {
			int left = reason.getLeftContextWidth() + reason.getLeftBonus();
			int right = reason.getRightContextWidth() + reason.getRightBonus();
			if(left + right > best) {
				best = left + right;
				count = 1;
			} else if (left + right == best) {
				count++;
			}
		}
		return Math.pow(2, best) * Math.log(count);
	}

}
