package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class ExhaustiveSelectAlgorithm extends AbstractSelectAlgorithm {


	@Override
	public List<Annotation<IGeneralizedHeuristicConstituent>> resolveOverlaps(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = weightCalculator.getWeights(crossingHypotheses);
		double best = -1;
		Set<Annotation<IGeneralizedHeuristicConstituent>> currentBest = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
		Set analyzed = new HashSet();
		currentBest.clear();
		analyzed.clear();
		for(int i = 0; i < crossingHypotheses.size(); i++) {
			Annotation<IGeneralizedHeuristicConstituent> a = crossingHypotheses.get(i);
			Set<Annotation<IGeneralizedHeuristicConstituent>> rest = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>(crossingHypotheses);
			rest.remove(a);
			Set<Annotation<IGeneralizedHeuristicConstituent>> chosen = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
			chosen.add(a);
			best = analyze(rest, chosen, best, currentBest, analyzed, weights);
		}
		List<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new ArrayList<Annotation<IGeneralizedHeuristicConstituent>>();
		for (Annotation<IGeneralizedHeuristicConstituent> anno : currentBest) {
			toReturn.add(newConstituent(anno));
		}
		return toReturn;
	}

	private double analyze(Set<Annotation<IGeneralizedHeuristicConstituent>> rest, Set<Annotation<IGeneralizedHeuristicConstituent>> chosen, double best, Set<Annotation<IGeneralizedHeuristicConstituent>> currentBest, Set analyzed, Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights) {
		double weight = 0;
		for (Annotation<IGeneralizedHeuristicConstituent> annotation : chosen) {
			weight += weights.get(annotation);
		}
		if(weight > best) {
			best = weight;
			currentBest.clear();
			currentBest.addAll(chosen);
		}
		for (Annotation<IGeneralizedHeuristicConstituent> a : rest) {
			if(chosen.contains(a)) continue;
			if(fits(a, chosen)) {
				Set<Annotation<IGeneralizedHeuristicConstituent>> newRest = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>(rest);
				newRest.remove(a);
				Set<Annotation<IGeneralizedHeuristicConstituent>> newChosen = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>(chosen);
				newChosen.add(a);
				if(analyzed.contains(newChosen)) continue;
				best = analyze(newRest, newChosen, best, currentBest, analyzed, weights);
				analyzed.add(newChosen);
			}
		}
		return best;
	}


	
	
	

}
