package de.uni_koeln.spinfo.tesla.component.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class MatrixLoader {

	private ArrayList<List<Annotation<IAnchoredElement>>> dataMatrix;
	ArrayList<Long> sequenceIds;
	ArrayList<Annotation<IAnchoredElement>> sequencesList;
	private Map<Long, Integer> typeMap = new HashMap<Long, Integer>();

	public ArrayList<int[]> loadData(List<String> signalIds, TeslaComponent component, IAnchoredElementAccessAdapter<IAnchoredElement> sequences, IAnchoredElementAccessAdapter<IAnchoredElement> words, double overall) {
		ArrayList<int[]> sequenceMatrix = new ArrayList<int[]>();
		dataMatrix = new ArrayList<List<Annotation<IAnchoredElement>>>();
		sequenceIds = new ArrayList<Long>(signalIds.size());
		sequencesList = new ArrayList<Annotation<IAnchoredElement>>();
		int empty = 0;
		double step = overall/signalIds.size();
		double current = 0;
		for (String sid : signalIds) {
			InputIterator<Annotation<IAnchoredElement>> sequenceIterator = sequences.getAnchoredElements(Range.forSignal(sid), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
			while(sequenceIterator.hasNext()) {
				Annotation<IAnchoredElement> sequence = sequenceIterator.next();
				sequenceIds.add(sequence.getId());
				sequencesList.add(sequence);
				InputIterator<Annotation<IAnchoredElement>> wordIterator = words.getAnchoredElements(sequence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
				ArrayList<Annotation<IAnchoredElement>> wordList = new ArrayList<Annotation<IAnchoredElement>>();
				while(wordIterator.hasNext()) {
					wordList.add(wordIterator.next());
				}
				wordList.trimToSize();
				dataMatrix.add(wordList);
				int[] array = new int[wordList.size()];
				for(int i = 0; i < wordList.size(); i++) {
					long typeId = wordList.get(i).getTypeId();
					Integer type = typeMap.get(typeId);
					if(type == null) {
						type = typeMap.size();
						typeMap.put(typeId, type);
					}
					array[i] = type;
				}
				sequenceMatrix.add(array);
				if(array.length == 0) empty++;
			}
			current += step;
			component.setProgress((int) current);
		}
		if(empty > 0) {
			Logger.getLogger(getClass()).warn("Inserted " + empty + " sequences of length 0");
		}
		sequenceMatrix.trimToSize();
		sequenceIds.trimToSize();
		return sequenceMatrix;
	}

	public ArrayList<List<Annotation<IAnchoredElement>>> getDataMatrix() {
		return dataMatrix;
	}

	public ArrayList<Long> getSequenceIds() {
		return sequenceIds;
	}
	

	public ArrayList<Annotation<IAnchoredElement>> getSequencesList() {
		return sequencesList;
	}

	public void setSequencesList(
			ArrayList<Annotation<IAnchoredElement>> sequencesList) {
		this.sequencesList = sequencesList;
	}

	public void release() {
		dataMatrix = null;
		sequenceIds = null;
		sequencesList = null;
	}
}
