package de.uni_koeln.spinfo.tesla.component.patterndetector;
import java.util.LinkedList;
import java.util.List;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;


public class INodeChain {
	
	private List<INode> linkedList;
	
	public INodeChain(){
		this.linkedList = new LinkedList<INode>();
	}
	
	public void addFrontNode(INode node){
		this.linkedList.add(0, node);
	}
	
	public int size(){
		return linkedList.size();
	}
	
	public String toString(){
		StringBuffer toReturn = new StringBuffer();
		for (INode node : linkedList) {
			toReturn.append(node.getValue() + " ");
		}
		return toReturn.toString();
	}	
	
	public INode getFirstNode(){
		return linkedList.get(0);
	}
	
	public INode getDeepestNode(){
		return linkedList.get(linkedList.size()-1);
	}
	
	public boolean isEmpty(){
		return linkedList.isEmpty();
	}
	
	@Override
	public boolean equals(Object other){
		return this.linkedList.equals(((INodeChain)other).linkedList);
	}
	
	@Override
	public int hashCode(){
		return linkedList.hashCode();
	}

}
