package tests;

import java.util.Set;

import org.junit.Test;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.NGramTree;
import de.uni_koeln.spinfo.tesla.component.patterndetector.INodeChain;
import de.uni_koeln.spinfo.tesla.component.patterndetector.PatternDetector;


public class PatternDetectorTests {
	
	
	
	@Test
	public void testLongestPatterns(){
		NGramTree tree = new NGramTree();
		int[] firstSeq = {1,1,2,2,1,2,1,2};
		int[] secSeq = {3,3,1,1,1,2,2,3};
		int[] thirdsec = {4,1,1,2,2,3};
		tree.insert(firstSeq, 1, false);
		tree.insert(secSeq, 2, false);
		tree.insert(thirdsec, 3, false);
		PatternDetector pd = new PatternDetector(tree);
		Set<INodeChain> longestPatterns = pd.getLongestPatterns(2);
		for (INodeChain iNodeChain : longestPatterns) {
			System.out.println(iNodeChain);
			INode deepestNode = iNodeChain.getDeepestNode();
			System.out.println("Value of deep node: "+ deepestNode.getValue());
			System.out.println("Depth of deep node: "+ deepestNode.getDepth());
			System.out.println("Positions of deep node: "+ deepestNode.getReferencedPositions());
		}		
	}
	
	@Test
	public void testAllPatterns(){
		NGramTree tree = new NGramTree();
		int[] firstSeq = {1,1,2,2,1,2,1,2};
		int[] secSeq = {3,3,1,1,1,2,2,3};
		int[] thirdsec = {4,1,1,2,2,3};
		tree.insert(firstSeq, 1, false);
		tree.insert(secSeq, 2, false);
		tree.insert(thirdsec, 3, false);
		PatternDetector pd = new PatternDetector(tree);
		Set<INodeChain> allPatterns = pd.getAllPatterns(4, 2);
		for (INodeChain iNodeChain : allPatterns) {
			System.out.println(iNodeChain);
		}
		
	}
}
