package de.uni_koeln.spinfo.tesla.component.alignhypothesis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl.AlignedSequence;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;

public 	class BoundsMarker implements Callable<AlignedSequence> {
	

	private ArrayList<int[]> sequenceMatrix;

	private Map<Integer, List<INode>> prefixNodes;
	private Map<Integer, List<INode>> suffixNodes;
	private int sequenceId;
	private ExecutorService service = Executors.newFixedThreadPool(2);
	
	public void setSequenceMatrix(ArrayList<int[]> sequenceMatrix) {
		this.sequenceMatrix = sequenceMatrix;
	}


	public void setPrefixNodes(Map<Integer, List<INode>> prefixNodes) {
		this.prefixNodes = prefixNodes;
	}

	public void setSuffixNodes(Map<Integer, List<INode>> suffixNodes) {
		this.suffixNodes = suffixNodes;
	}

	@Override
	public AlignedSequence call() throws Exception {
		return process(sequenceId);
	}
	
	public void setSequenceId(int sequenceId) {
		this.sequenceId = sequenceId;
	}
	
	public AlignedSequence process(final int sequenceId) throws InterruptedException, ExecutionException {
			final int[] sequence = sequenceMatrix.get(sequenceId);
			final AlignedSequence as = new AlignedSequence(sequenceId, sequence.length);
			Runnable suffix = new Runnable() {
				
				@Override
				public void run() {
					Set<Integer> processed = new HashSet<Integer>();
					for(int i = 0; i < sequence.length; i++) {
						int type = sequence[i];
						if(processed.contains(type)) continue;
						processed.add(type);
						final List<INode> suffixList = suffixNodes.get(type);
						if(suffixList == null) continue;
						for (INode node : suffixList) {
							/* Müsste geändert werden:
							 * 
							 * Wenn die Knotenliste vom tiefsten bis zum obersten Knoten
							 * durchlaufen wird, dann könnte man es sich sparen, Elemente
							 * mehr als einmal zu betrachten. Allerdings bringt das nur etwas,
							 * wenn das bilden einer Schnittmenge effizienter wäre als das
							 * betrachten jedes Elements - das geht wohl kaum.
							 * 
							 */
							Collection<IPosition> positions = node.getReferencedPositions();
							for (IPosition position : positions) {
								if(sequenceId != position.getSequenceIndex()) continue;
								IPosition myPosition = position;
								if(myPosition.getElementIndex() < 0 || myPosition.getElementIndex() >= sequence.length) {
									// Todo: handle empty constituents at start or end
									continue;
								}
								as.registerStartHypothesis(myPosition, positions, node.getDepth(), sequenceMatrix);						
							}
						}
					}
					as.trimStartNodes();
				}
			
				
			};
			Future<?> suffixFuture = service.submit(suffix);
			Runnable prefix = new Runnable() {
				
				@Override
				public void run() {
					
					Set<Integer> processed = new HashSet<Integer>();
					for(int i = 0; i < sequence.length; i++) {
							int type = sequence[i];
							if(processed.contains(type)) continue;
							processed.add(type);
							final List<INode> prefixList = prefixNodes.get(type);
							if(prefixList == null) continue;
							for (INode node : prefixList) {
								Collection<IPosition> positions = node.getReferencedPositions();
								for (IPosition position : positions) {
									if(position.getSequenceIndex() != sequenceId) continue;
									IPosition myPosition = position;
									if(myPosition.getElementIndex() < 0 || myPosition.getElementIndex() >= sequence.length) {
										// Todo: handle empty constituents at start or end
										continue;
									}
									as.registerEndHypothesis(myPosition, positions, node.getDepth(), sequenceMatrix);						
								}
							}
						}
					as.trimEndNodes();
					}


				
			};
			Future<?> prefixFuture = service.submit(prefix);
			suffixFuture.get();
			prefixFuture.get();
			return as;
	}


}
