package de.uni_koeln.spinfo.tesla.component.alignhypothesis.data;

import java.util.List;
import java.util.SortedSet;

import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;

public interface IAlignedSequence extends DataObject{

	int getLength();

	int getSequenceId();

	SortedSet<Short> getStartIndices();

	SortedSet<Short> getEndIndices();

	List<IMatch> getMatches(int start, int end);

	public List<IMatch> getSingleEndMatches(int end, List<int[]> sequenceMatrix);
	
	public List<IMatch> getSingleStartMatches(int start, List<int[]> sequenceMatrix);

	List<Annotation<IAnchoredElement>> getWords();

}
