package de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl;


public class ContextPosition implements Comparable<ContextPosition> {
	
	private final byte contextLength;
	private final byte wordPos;
	private final int sequence;
	
	public ContextPosition(int sequence, int wordPos, int depth) {
		this.wordPos = (byte) (wordPos-127);
		this.contextLength = (byte) depth;
		this.sequence = sequence;
	}

	@Override
	public boolean equals(Object obj) {
		if(obj == null) return false;
		ContextPosition other = (ContextPosition) obj;
		return sequence() == other.sequence() && wordPos == other.wordPos;
	}
	
	@Override
	public int hashCode() {
		return sequence() * 36229 + wordPos * 541;
	}
	
	public int sequence() {
		return sequence;
	}

	public short wordPos() {
		return (short) (127+wordPos);
	}
	
	public byte getContextLength() {
		return contextLength;
	}
	
	@Override
	public int compareTo(ContextPosition o) {
		int result = sequence() - o.sequence();
		if(result == 0) {
			return wordPos - o.wordPos;
		}
		return result;
	}

	@Override
	public String toString() {
		return sequence + "/" + wordPos();
	}
	
}
