package de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.impl;

import de.uni_koeln.spinfo.tesla.component.alignhypothesis.data.IMatch;


public class Match implements Comparable<Match>, IMatch {

	public final ContextPosition start, end;
	
	public Match(ContextPosition start, ContextPosition end) {
		this.start = start;
		this.end = end;
		if(start.sequence() != end.sequence()) {
			throw new RuntimeException("Match must be within the same sequence!");
		}
		if(start.wordPos() == end.wordPos()) {
			throw new RuntimeException("Can't match zero, this is silly!");
		}
	}

	public int sequence() {
		return start.sequence();
	}

	@Override
	public int compareTo(Match o) {
		int result = start.compareTo(o.start);
		if(result == 0) {
			return end.compareTo(o.end);
		}
		return result;
	}

	@Override
	public String toString() {
		return start.toString() + " to " + end.toString();
	}

	@Override
	public ContextPosition end() {
		return end;
	}

	@Override
	public ContextPosition start() {
		return start;
	}
	
}
