package de.uni_koeln.spinfo.tesla.component.misc;

import java.util.List;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.TypeMapping;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.access.RangeFilterAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.AnnotationRangeFilter;
import de.uni_koeln.spinfo.tesla.roles.filter.impl.tunguska.data.Filter;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import de.uni_koeln.spinfo.tesla.runtime.persistence.DataObject;

@Component(threadMode=ThreadMode.CUSTOM, 
		author=@Author(	author="Stephan Schwiebert", 
						email="sschwieb@spinfo.uni-koeln.de", 
						web="http://www.spinfo.uni-koeln.de/space/sschwieb", 
						organization="Sprachliche Informationsverarbeitung"),
		description=@Description(name="SOG (Filter)",
								 summary="Generates hypotheses about paradigmatic structures in sequences, " +
								 		"based on the length of the shared context of two phrases." +
								 		" A hypothesis is accepted if at least one of the found contexts matches the configured restrictions.",
								 bigO="not so bad, in general",
								 version="1.0",
								 reusableResults=true))
public class TestFilter extends TeslaComponent {
	
	
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequences", 
    		description="The sequences to align (for instance, sentences)")
    private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
    
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name="Sequence Items",
    		description="The items to align (for instance, words)")
	protected IAnchoredElementAccessAdapter<IAnchoredElement> words;
    
    @AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Constituents", 
    		description="The sequences to align (for instance, sentences)")
    private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> constituentIn;
    
    
	 @OutputAdapter(dataObject=Filter.class, name="Filter", type=DefaultTunguskaOutputAdapter.class, 
			 accessAdapterImpl=RangeFilterAccessAdapter.class, description="The generated filter, which can be applied on all annotations")
	 @RoleDescription(value="de.uni_koeln.spinfo.tesla.roles.filter.Filter")
	 private IOutputAdapter<Filter<DataObject>> outputAdapter;
	 
	 @Configuration(defaultValue="false", name="Invert matching", min=1, max=1, description="If enabled, an annotation is not accepted if" +
		 		" it matches an annotation from 'Filter'. If disabled, an annotation will be accepted if it " +
		 		" matches an annotation from 'Filter'")
		 private boolean invertMatching = false;
	     
    @Run
    public Result run() {
    	InputIterator<String> signals = sequences.getAllSignalIds();
    	signals.registerAsProgressBar(this);
    	while(signals.hasNext()) {
    		String signalId = signals.next();
    		InputIterator<Annotation<IAnchoredElement>> sentences = sequences.getAnchoredElements(Range.forSignal(signalId), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
    		AnnotationRangeFilter filter = new AnnotationRangeFilter(invertMatching);
    		while(sentences.hasNext() && !cancelled()) {
    			Annotation<IAnchoredElement> sentence = sentences.next();
    			InputIterator<Annotation<IAnchoredElement>> elements = words.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class);
    			List<Annotation<IAnchoredElement>> wordList = asList(elements);
    			InputIterator<Annotation<IGeneralizedHeuristicConstituent>> constituents = constituentIn.getAnchoredElements(sentence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IGeneralizedHeuristicConstituent.class);
    			while(constituents.hasNext() && !cancelled()) {
    				Annotation<IGeneralizedHeuristicConstituent> constituent = constituents.next();
    				if(accept(constituent, sentence, wordList)) {
    					filter.add(constituent);
    				}
    			}
    		}
    		Annotation<AnnotationRangeFilter> anno = outputAdapter.getAnnotationFactory().newSignalAnnotation(signalId, filter, TypeMapping.NONE);
			outputAdapter.store(anno);
    	}
    	return cancelled() ? Result.CANCELLED : Result.OK;
    }

	private boolean accept(
			Annotation<IGeneralizedHeuristicConstituent> constituent,
			Annotation<IAnchoredElement> sentence,
			List<Annotation<IAnchoredElement>> wordList) {
		IGeneralizedHeuristicConstituent data = constituent.getDataObject();
		double elements = wordList.size();
		double constituentStart = 0;
		for(int i = 0; i < wordList.size(); i++) {
			if(wordList.get(i).getLeftAnchor() == constituent.getLeftAnchor()) {
				constituentStart = -i;
				break;
			}
		}
		double constituentEnd = 0;
		for(int i = 0; i < wordList.size(); i++) {
			if(wordList.get(i).getRightAnchor() == constituent.getRightAnchor()) {
				constituentEnd = i;
				break;
			}
		}
		// Probability that this constituent is correct:
		double randomProbability = (elements-1)*elements/2-1;
		
		
		
		return false;
	}
}
