package de.uni_koeln.spinfo.tesla.component.ngramtree.access.impl;


import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaAccessAdapter;
import de.uni_koeln.spinfo.tesla.component.ngramtree.access.INgramTreeAccessAdapter;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INgramTree;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl.NGramTree;

public class NGramTreeAccessAdapter extends DefaultTunguskaAccessAdapter<INgramTree> implements INgramTreeAccessAdapter<INgramTree> {

	public NGramTreeAccessAdapter() {
		super(INgramTree.class);
	}

	private static final long serialVersionUID = -8019396101338800453L;

	private NGramTree tree;
	
	private void loadTree() {
		if(tree != null) return;
		tree = (NGramTree) super.getAllAnnotations(INgramTree.class).next().getDataObject();
	}
	
	public INgramTree getTree() {
		loadTree();
		return tree;
	}
	

	@Override
	public void release() {
		tree = null;
	}

}
