package de.uni_koeln.spinfo.tesla.component.ngramtree.data.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;

import de.uni_koeln.spinfo.tesla.component.ngramtree.data.INode;
import de.uni_koeln.spinfo.tesla.component.ngramtree.data.IPosition;
import de.uni_koeln.spinfo.tesla.component.util.GoogleHashSet;

public class Node implements Comparable<Node>, INode, Serializable {
	
	private static final long serialVersionUID = 8718427149468641624L;
	private GoogleHashSet<Node> children;
	private int value;
	private final byte depth;
	//private TIntHashSet sequences = new TIntHashSet();
	private Collection<IPosition> sequences = new GoogleHashSet<IPosition>(); 
	private Node parent;
	private int id;
	
	private static final byte NOT_SET = 0, YES = 1, NO = 2;
	
	private final static int posMask = 255;
	
	private byte branching = NOT_SET;
	
	private static int nextId = 0;
	
	public Node(int value, int depth) {
		this.value = value;
		this.depth = (byte) (depth-127);
		this.id = nextId++;
	}
	
	public static int encode(int sequenceId, int wordPos) {
		return sequenceId << 8 |( wordPos & posMask);
	}
	
	public static PosPair decode(int value) {
		int s = value >> 8;
		int w = value & posMask;
		return PosPair.newPair(s, (short) w);
	}
	
	public static int sequence(int value) {
		return value >> 8;
	}
	
	/**
	 * Appends an element to the current node, and returns the
	 * child node corresponding to the element.
	 * @param value the element to insert
	 * @param sequenceId the sequence id of the element
	 * @param wordPos the position of the element within the sequence
	 * @param searchDummy
	 * @param tree the tree this node belongs to
	 * @return
	 */
	public synchronized Node append(final int value, final int sequenceId, final short wordPos, Node searchDummy, NGramTree tree) {
		if(children == null) {
			children = new GoogleHashSet<Node>();
		}
		searchDummy.value = value;
		Node child = (Node) children.get(searchDummy);
		if(child == null) {
			child = new Node(value, getDepth()+1);
			child.parent = this;
			children.add(child);
		}
		//int v = encode(sequenceId, wordPos);
		child.sequences.add(new PosPair(sequenceId, wordPos));
		return child;
	}
	
	public Node getParent() {
		return parent;
	}

	@Override
	public int hashCode() {
		return value * 1023;
	}
	
	@Override
	public boolean equals(Object obj) {
		return value == ((Node)obj).value;
	}
	
	public GoogleHashSet<INode> getChildren() {
		Set c = children;
		return (GoogleHashSet<INode>) c;
	}
	
	public int getValue() {
		return value;
	}
	
	public Collection<IPosition> getReferencedPositions() {
		return sequences;
//		List<IPosition> positions = new ArrayList<IPosition>(sequences.size());
//		TIntIterator it = this.sequences.iterator();
//		while(it.hasNext()) {
//			positions.add(decode(it.next()));
//		}
//		return positions;
	}

	@Override
	public int compareTo(Node o) {
		return value - o.value;
	}
	
	@Override
	public String toString() {
		return "Node " + value + "/" + getDepth() + "(" + sequences + ")";
	}
	
//	public Set<Integer> getReferencedSequenceIds() {
//		Set<Integer> sentenceIds = new HashSet<Integer>();
//		TIntIterator it = this.sequences.iterator();
//		while(it.hasNext()) {
//			sentenceIds.add(sequence(it.next()));
//		}
//		return sentenceIds;
//	}

	public int getDepth() {
		return 127 + depth;
	}
	

	public void clearSequenceMap() {
		if(sequences == null) return;
		sequences.clear();
		sequences = null;
	}

	public void clearChildren() {
		if(children == null) return;
		children.clear();
		children = null;
	}

	public void updateBranching() {
		if(branching == NOT_SET) {
			if(children == null || children.size() < 2) {
				branching = NO;
			} else {
				branching = YES;
			}
		}
	}
	
	public boolean isBranching() {
		return branching == YES;
	}
	
	public void setBranching(boolean branching) {
		if(branching) {
			this.branching = YES;
		} else {
			this.branching = NO;
		}
	}
	
	public void addPosition(IPosition position) {
		sequences.add(position);
		//sequences.add(encode(position.getSequenceIndex(), position.getElementIndex()));
	}
	
	public int getId() {
		return id;
	}

	public void setPositions(Collection<IPosition> others) {
		this.sequences = others;
	}

	public void setParent(Node parent) {
		this.parent = parent;
	}
}