package de.uni_koeln.spinfo.tesla.component.paradigms;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.JustifiedHypothesis;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class Categorizer {

	
	public static final String UNIQUE = "Unique";

	public static final String CONSTITUENT = "Constituent";

	public static final String RIGHT_CONTEXT = "Right Context";

	public static final String LEFT_CONTEXT = "Left Context";

	public static final String BOTH_CONTEXTS = "Both Contexts";

	private final String categorizeMethod;


	private final Map<Long, String> ntMap = new HashMap<Long, String>();

	
	private long nextMapping = 1;

	public Categorizer(String categorizeMethod) {
		this.categorizeMethod = categorizeMethod;
	}

	private synchronized String getNt(long nt) {
		String label = ntMap.get(nt);
		if(label == null) {
			label = (ntMap.size()+1)+"";
			ntMap.put(nt, label);
		}
		return label;
	}

	public void categorize(
			JustifiedHypothesis constituent, GeneralizedConstituent data,
			List<Annotation<IAnchoredElement>> words, int firstIncluded, int firstNotIncluded, int maxLeft, int maxRight) {
		long mapping = 1;
		if(BOTH_CONTEXTS.equals(categorizeMethod) || LEFT_CONTEXT.equals(categorizeMethod)) {
			mapping *= 31;
			if(firstIncluded == 0) {
				mapping *= 31;
			}
			for(int i = Math.max((int)(firstIncluded - constituent.getAverageLeft()),0); i < firstIncluded; i++) {
				mapping = mapping * 31 + words.get(i).getTypeId();
			}
		}
		if(BOTH_CONTEXTS.equals(categorizeMethod) || RIGHT_CONTEXT.equals(categorizeMethod)) {
			mapping *= 31;
			if(firstNotIncluded == words.size()) {
				mapping *= 31;
			}
			for(int i = firstNotIncluded; i < (int) (firstNotIncluded + constituent.getAverageRight()) && i < words.size(); i++) {
				mapping = mapping * 31 + words.get(i).getTypeId();
			}
		}
		if(UNIQUE.equals(categorizeMethod)) {
			mapping = nextMapping++;
		}
		if(CONSTITUENT.equals(categorizeMethod)) {
			for(int i = constituent.getLeft(); i < constituent.getRight(); i++) {
				mapping = mapping * 31 + words.get(i).getTypeId();
			}
		}
		//data.setContextInfo(sequenceIds.size(), matches.size(), allMatches, left, right);
		data.addCategory(getNt(mapping));
	}
	
	
}
