package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.Collection;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IAnnotationFactory;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public abstract class AbstractSelectAlgorithm implements ISelectAlgorithm {


	protected IWeightCalculator weightCalculator;
	protected IAnnotationFactory annotationFactory;

	
	@Override
	public void setWeightCalculator(IWeightCalculator weightCalculator) {
		this.weightCalculator = weightCalculator;
	}


	@Override
	public void setAnnotationFactory(IAnnotationFactory annotationFactory) {
		this.annotationFactory = annotationFactory;
	}

	protected Annotation newConstituent(Annotation<IGeneralizedHeuristicConstituent> a) {
		GeneralizedConstituent toClone = (GeneralizedConstituent) a.getDataObject();
		GeneralizedConstituent object = new GeneralizedConstituent();
		object.setCategory(toClone.getCategory());
		object.setLabel(toClone.getLabel());
		object.addContextDetails(toClone.getMatchDetails());
		Annotation anno = annotationFactory.newAnnotation(a.getLeftAnchor(), a.getRightAnchor(), a.getSignalId(), object, a.getTypeId());
		return anno;
	}
	
	protected boolean fits(
			Annotation<IGeneralizedHeuristicConstituent> annotation,
			Collection<Annotation<IGeneralizedHeuristicConstituent>> toReturn) {
		for (Annotation<IGeneralizedHeuristicConstituent> anno : toReturn) {
			// |---------| (anno)
			//     |---------| (annotation)
			if(anno.getLeftAnchor() < annotation.getLeftAnchor() && anno.getRightAnchor() > annotation.getLeftAnchor() && anno.getRightAnchor() < annotation.getRightAnchor()) {
				return false;
			}
			//      |---------| (anno)
			// |---------| (annotation)
			if(anno.getLeftAnchor() > annotation.getLeftAnchor() && anno.getLeftAnchor() < annotation.getRightAnchor() && anno.getRightAnchor() > annotation.getRightAnchor()) {
				return false;
			}
		}
		return true;
	}



}
