package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IOutputAdapter;
import de.uni_koeln.spinfo.tesla.annotation.adapter.InputIterator;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Order;
import de.uni_koeln.spinfo.tesla.annotation.adapter.queryconstraints.Range;
import de.uni_koeln.spinfo.tesla.annotation.adapter.tunguska.DefaultTunguskaOutputAdapter;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.GeneralizedConstituent;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.impl.Reason;
import de.uni_koeln.spinfo.tesla.roles.core.access.IAnchoredElementAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.core.data.IAnchoredElement;
import de.uni_koeln.spinfo.tesla.roles.parser.access.IConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.roles.parser.impl.tunguska.access.TunguskaConstituentAccessAdapter.DefaultTunguskaConstituentAccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.Result;
import de.uni_koeln.spinfo.tesla.runtime.TeslaComponent;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.AccessAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Author;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Component;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Configuration;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Description;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.OutputAdapter;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.RoleDescription;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.Run;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ServerSubclassChoice;
import de.uni_koeln.spinfo.tesla.runtime.component.annotations.ThreadMode;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import edu.emory.mathcs.backport.java.util.Collections;

@Component(threadMode=ThreadMode.NOT_SUPPORTED, 
		author=@Author(	author="Stephan Schwiebert", 
						email="sschwieb@spinfo.uni-koeln.de", 
						web="http://www.spinfo.phil-fak.uni-koeln.de/sschwieb.html", 
						organization="Sprachliche Informationsverarbeitung"),
		description=@Description(name="Suffix Export",
								 summary="Test select method",
								 bigO="unknown",
								 version="1.0",
								 reusableResults=true))
public class ExportExchangables extends TeslaComponent {

	private static final long serialVersionUID = 879812013823937578L;

	
	@AccessAdapter(role="de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector", name="Input")
	private IConstituentAccessAdapter<IGeneralizedHeuristicConstituent> hypotheses;
	
	@OutputAdapter(dataObject=GeneralizedConstituent.class, type=DefaultTunguskaOutputAdapter.ProtoStuff.class, name="Constituents", 
			accessAdapterImpl=DefaultTunguskaConstituentAccessAdapter.class,
			description="All constituents detected by the parser")
	@RoleDescription("de.uni_koeln.spinfo.tesla.roles.structure.bootstrapping.GeneralizedHeuristicConstituentDetector")
	private IOutputAdapter<GeneralizedConstituent> constituentOut;
	
	@AccessAdapter(role = "de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", name = "Sequence Items", description = "The items to align (for instance, words)")
	private IAnchoredElementAccessAdapter<IAnchoredElement> words;
	
//	 @Configuration(editor="de.uni_koeln.spinfo.tesla.client.ui.editors.form.configurations.itemeditors.ServerChoiceEditor",
//			    defaultValue="de.uni_koeln.spinfo.tesla.component.paradigms.select.SimpleWeightCalculator",
//	    		name="Hypothesis Weight Calculator", restriction=ServerSubclassChoice.class,
//	    		description="The algorithm to compute the weight of a hypothesis.", 
//	    		evaluateOnServer=true, 
//	    		editorConfiguration={"de.uni_koeln.spinfo.tesla.component.paradigms.select.IWeightCalculator", "single", "class"})
	private String weightCalculatorClass = SimpleWeightCalculator.class.getName();
	
		@AccessAdapter(role = "de.uni_koeln.spinfo.tesla.roles.core.AnchoredElementGenerator", 
				name = "Sequences", description = "The sequences to align (for instance, sentences)")
		private IAnchoredElementAccessAdapter<IAnchoredElement> sequences;
	 
	class InContext implements Comparable<InContext>{
		
		String leftCtx, rightCtx;
		
		int leftLength, leftBonus, rightLength, rightBonus;
		
		Set<String> replacements = new HashSet<String>();
		
		double baseLength;
		
		double getScore() {
			return Math.pow(4, leftLength + leftBonus + rightLength + rightBonus) *  (leftLength + rightLength)/(baseLength-1);
			//return Math.pow(4, leftLength + leftBonus) + Math.pow(4, rightLength + rightBonus);
		}

		@Override
		public int compareTo(InContext o) {
			return Double.compare(getScore(), o.getScore());
		}
		
		
	}
	
	@Run
	public Result run() throws Exception {
		InputIterator<String> signals = sequences.getAllSignalIds();
		signals.registerAsProgressBar(this);
		Map<String, InContext> contexts = new HashMap<String, InContext>();
		while(signals.hasNext()) {
			String signalId = signals.next();
			InputIterator<Annotation<IAnchoredElement>> seqs = sequences.getAnchoredElements(Range.forSignal(signalId), null, IAnchoredElement.class);
			while(seqs.hasNext()) {
				Annotation<IAnchoredElement> sequence = seqs.next();
				List<Annotation<IAnchoredElement>> items = words.getAnchoredElements(sequence.getRange(false), Order.ORDER_LEFTANCHOR_ASC, IAnchoredElement.class).toList();
				InputIterator<Annotation<IGeneralizedHeuristicConstituent>> hypos = hypotheses.getAnnotations(sequence.getRange(false), null);
				while(hypos.hasNext()) {
					Annotation<IGeneralizedHeuristicConstituent> hypothesis = hypos.next();
					GeneralizedConstituent gc = (GeneralizedConstituent) hypothesis.getDataObject();
					List<Reason> reasons = gc.getMatchDetails();
					Set<String> analyzed = new HashSet<String>();
					for (Reason reason : reasons) {
						String s = reason.getLeftContextWidth() + "_" + reason.getRightContextWidth() + "_" + reason.getLeftBonus() + "_" + reason.getRightBonus();
						if(!analyzed.add(s)) {
							continue;
						}
						
						StringBuilder sb = new StringBuilder();
						List<String> left = new ArrayList<String>();
						List<String> right = new ArrayList<String>();
						for(int i = gc.getStart() - 1; i >= gc.getStart() - reason.getLeftContextWidth() && i >= 0; i--) {
							sb.append(items.get(i).getTypeId() + "_");
							left.add((String) items.get(i).getSignalContent());
						}
						if(reason.getLeftBonus() > 0) {
							sb.append("START");
							left.add("START");
						}
						sb.append(" ");
						for(int i = gc.getEnd(); i <= gc.getEnd() + reason.getRightContextWidth() && i < items.size(); i++) {
							sb.append(items.get(i).getTypeId() + "_");
							right.add((String) items.get(i).getSignalContent());
						}
						if(reason.getRightBonus() > 0) {
							sb.append("END");
							right.add("END");
						}
						InContext ctx = contexts.get(sb.toString());
						if(ctx == null) {
							ctx = new InContext();
							contexts.put(sb.toString(), ctx);
							Collections.reverse(left);
							ctx.leftCtx = left.toString();
							ctx.rightCtx = right.toString();
							ctx.leftLength = reason.getLeftContextWidth();
							ctx.rightLength = reason.getRightContextWidth();
							ctx.leftBonus = reason.getLeftBonus();
							ctx.rightBonus = reason.getRightBonus();
							ctx.baseLength = gc.getSentenceLength();
						}
						List<String> hypo = new ArrayList<String>();
						for(int i = gc.getStart(); i < gc.getEnd(); i++) {
							hypo.add((String) items.get(i).getSignalContent());
						}
						
						ctx.replacements.add(hypo.toString());
						
					}
				}
			}			
		}
		List<InContext> elements = new ArrayList<InContext>(contexts.values());
		Collections.sort(elements);
		Iterator<InContext> all = elements.iterator();
		BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream("output_classes.txt")));
		while(all.hasNext()) {
			InContext ctx = all.next();
			if(ctx.replacements.size() == 1) continue;
			bw.write("****************************************\n");
			bw.write(ctx.leftCtx + "\t ... \t" + ctx.rightCtx + "\t" + (Math.pow(2, ctx.leftLength + ctx.leftBonus) + Math.pow(2, ctx.rightLength + ctx.rightBonus))  + "\n");
			Set<String> replacements = ctx.replacements;
			for (String string : replacements) {
				bw.write("\t" + string + "\n");
			}
			bw.write("\n");
		}
		bw.close();
		return cancelled() ? Result.CANCELLED : Result.OK;
	}

}
