package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;
import edu.emory.mathcs.backport.java.util.Collections;

public class GreedySelectAlgorithm extends AbstractSelectAlgorithm {


	@Override
	public List<Annotation<IGeneralizedHeuristicConstituent>> resolveOverlaps(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		List<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new ArrayList<Annotation<IGeneralizedHeuristicConstituent>>();
		final Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = weightCalculator.getWeights(crossingHypotheses);
		Collections.sort(crossingHypotheses, new Comparator<Annotation<IGeneralizedHeuristicConstituent>>() {

			@Override
			public int compare(Annotation<IGeneralizedHeuristicConstituent> o1,
					Annotation<IGeneralizedHeuristicConstituent> o2) {
				return Double.compare(weights.get(o2), weights.get(o1));
			}
		});
		for(int i = 0; i < crossingHypotheses.size(); i++) {
			Annotation<IGeneralizedHeuristicConstituent> a = crossingHypotheses.get(i);
			if(fits(a, toReturn)) {
				Annotation anno = newConstituent(a);
				toReturn.add(anno);
			}
		}
		return toReturn;
	}


	
	
	

}
