package de.uni_koeln.spinfo.tesla.component.paradigms.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

import de.uni_koeln.spinfo.tesla.annotation.adapter.IAnnotationFactory;
import de.uni_koeln.spinfo.tesla.component.paradigms.data.IGeneralizedHeuristicConstituent;
import de.uni_koeln.spinfo.tesla.runtime.persistence.Annotation;

public class RandomizedSelectAlgorithm extends ExhaustiveSelectAlgorithm {

	private Random random = new Random();
	
	private GreedySelectAlgorithm greedy = new GreedySelectAlgorithm();
	
	@Override
	public void setWeightCalculator(IWeightCalculator weightCalculator) {
		super.setWeightCalculator(weightCalculator);
		greedy.setWeightCalculator(weightCalculator);
	}

	@Override
	public void setAnnotationFactory(IAnnotationFactory annotationFactory) {
		super.setAnnotationFactory(annotationFactory);
		greedy.setAnnotationFactory(annotationFactory);
	}

	
	@Override
	public List<Annotation<IGeneralizedHeuristicConstituent>> resolveOverlaps(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		if(crossingHypotheses.size() < 30) {
			return super.resolveOverlaps(crossingHypotheses);
		}
		Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights = weightCalculator.getWeights(crossingHypotheses);
		List<Annotation<IGeneralizedHeuristicConstituent>> greedyResult = greedy.resolveOverlaps(crossingHypotheses);
		double best = 0;
		Map<Annotation<IGeneralizedHeuristicConstituent>, Double> tmp = weightCalculator.getWeights(greedyResult);
		for (Annotation<IGeneralizedHeuristicConstituent> annotation : greedyResult) {
			best += tmp.get(annotation);
		}
		Set<Annotation<IGeneralizedHeuristicConstituent>> currentBest = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
		currentBest.clear();
		currentBest.addAll(greedyResult);
		for(int i = 0; i < 2000; i++) {
			Collections.shuffle(crossingHypotheses, random);
			Set<Annotation<IGeneralizedHeuristicConstituent>> guessed = guess(crossingHypotheses);
			double weight = getWeight(guessed, weights);
			if(weight >= best) {
				best = weight;
				currentBest = guessed;
			}
		}
		List<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new ArrayList<Annotation<IGeneralizedHeuristicConstituent>>();
		for (Annotation<IGeneralizedHeuristicConstituent> anno : currentBest) {
			toReturn.add(newConstituent(anno));
		}
		return toReturn;
	}

	protected double getWeight(Collection<Annotation<IGeneralizedHeuristicConstituent>> guessed, Map<Annotation<IGeneralizedHeuristicConstituent>, Double> weights) {
		double weight = 0;
		for (Annotation<IGeneralizedHeuristicConstituent> annotation : guessed) {
			weight += weights.get(annotation);
		}
		return weight;
	}

	private Set<Annotation<IGeneralizedHeuristicConstituent>> guess(List<Annotation<IGeneralizedHeuristicConstituent>> crossingHypotheses) {
		Set<Annotation<IGeneralizedHeuristicConstituent>> toReturn = new HashSet<Annotation<IGeneralizedHeuristicConstituent>>();
		for(int i = 0; i < crossingHypotheses.size(); i++) {
			Annotation<IGeneralizedHeuristicConstituent> chosen = crossingHypotheses.get(i);
			if(fits(chosen, toReturn)) {
				toReturn.add(chosen);
			}
		}
		return toReturn;
	}

	

}
